% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBgetXY.R
\name{DBgetXY}
\alias{DBgetXY}
\title{Database - Extracts actual plot coordinates from the FIA Oracle database.}
\usage{
DBgetXY(
  states = NULL,
  RS = NULL,
  invtype = "ANNUAL",
  evalid = NULL,
  evalCur = FALSE,
  evalEndyr = NULL,
  evalAll = FALSE,
  evalType = "ALL",
  measCur = FALSE,
  measEndyr = NULL,
  allyrs = FALSE,
  invyrs = NULL,
  measyrs = NULL,
  intensity1 = FALSE,
  issp = FALSE,
  returndata = TRUE,
  savedata = FALSE,
  exportsp = FALSE,
  savedata_opts = NULL
)
}
\arguments{
\item{states}{String or numeric vector. Name (e.g., 'Arizona','New Mexico')
or code (e.g., 4, 35) of state(s) for evalid. If all states in one or more
FIA Research Station is desired, set states=NULL and use RS argument to
define RS.}

\item{RS}{String vector. Name of research station(s) to get public XY
coordinates for ('RMRS','SRS','NCRS','NERS','PNWRS'). Do not use if states 
is populated. See FIESTA::ref_statecd for reference to RS and states.}

\item{invtype}{String. Type of FIA inventory to extract ('PERIODIC',
'ANNUAL').  Only one inventory type (PERIODIC/ANNUAL) at a time.}

\item{evalid}{Integer. Inventory span defining variable. Extract public 
XY coordinates for a specific FIA Evaluation (See details for more 
information about FIA Evaluations).}

\item{evalCur}{Logical. Inventory span defining variable. If TRUE, extract
public XY coordinates for the most current FIA Evaluation for each state.}

\item{evalEndyr}{YYYY. Inventory span defining variable. Extract public XY 
coordinates for the FIA Evaluation(s) ending in the specified evalEndyr(s). 
If more than one state and different Evaluations by state are desired, 
input a named list object with evalEndyr by state (e.g., list(Utah=2014, 
Colorado=2013).}

\item{evalAll}{Logical. Inventory span defining variable. If TRUE, extract
public XY coordinates for all FIA Evaluations for each state.}

\item{evalType}{String vector. The type(s) of FIA Evaluation of interest 
('ALL', 'CURR', VOL', 'GRM', 'P2VEG', 'DWM", 'INV', 'REGEN', 'CRWN'). 
The evalType 'ALL' includes nonsampled plot coordinates; 'CURR' includes 
plot coordinates used for area estimates; 'VOL' includes plot coordinates 
used for area and/or tree estimates; 'GRM' includes plot coordinates used 
for growth, removals, mortality, and change estimates (evalType %in% 
c(GROW, MORT, REMV, CHNG)). Multiple types are accepted. See details below 
and FIA database manual for regional availability and/or differences.}

\item{measCur}{Logical. Inventory span defining variable. If TRUE, extract
public XY coordinates with most current sampled measurement for state(s).}

\item{measEndyr}{Logical. Inventory span defining variable. If TRUE, extract
XY public coordinates with most current sampled measurement for state(s) 
for years measured in or before measEndyr.}

\item{allyrs}{Logical. Inventory span defining variable. If TRUE, extract
all annual inventory years in database for each state.}

\item{invyrs}{YYYY vector. Inventory span defining variable. Extract public
XY coordinates by state for the specified inventory year(s) (e.g., 
c(2000, 2001, 2002)). If more than one state and different inventory years 
are desired, input a named list object with years labeled by state 
(e.g., list(Utah=2000:2009, Colorado=c(2002,2003,2005)).}

\item{measyrs}{YYYY vector. Measurement year span defining variable. Extract
public XY coordinates by state for the specified measurement year(s) 
(e.g., c(2000, 2001, 2002)). If more than one state and different 
measurement years are desired, input a named list object with years labeled 
by state (e.g., list(Utah=2000:2009, Colorado=c(2002,2003,2005)).}

\item{intensity1}{Logical. If TRUE, includes only XY coordinates where 
INTENSITY = 1 (FIA base grid).}

\item{issp}{Logical. If TRUE, returns spatial XY data as a list object with
query.}

\item{returndata}{Logical. If TRUE, returns XY data as a list object with
query.}

\item{savedata}{Logical. If TRUE, saves XY data to outfolder as comma-delimited
file (*.csv).}

\item{exportsp}{Logical. If TRUE, exports data as spatial.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}
}
\value{
if returndata=TRUE, a list of the following objects: 
\item{xy*_PUBLIC}{ Data frame. XY data from FIA's public database. If 
measCur=TRUE, named xyCur_PUBLIC, else named xy_PUBLIC. The data frame 
has 10 columns ('PLT_CN', 'LON_PUBLIC', 'LAT_PUBLIC', 'STATECD', 'UNITCD',
'COUNTYCD', 'PLOT', 'INTENSITY', 'PLOT_ID' (ID+STATECD+UNTCD+COUNTYCD+PLOT), 
'COUNTYFIPS'. If issp=TRUE, returns an sf object. }
\item{xyqry}{ String. Query to extract coordinates. }
\item{xvar}{ String. Name of X variable in xy*_PUBLIC. }
\item{yvar}{ String. Name of Y variable in xy*_PUBLIC. }

If savedata=TRUE, outputs the xy*_PUBLIC as out_fmt to outfolder. 
If exportsp=TRUE, the output xy data are saved as spatial layer.
}
\description{
Extracts actual plot coodinates for the most current measurement of each
plot in the database.
}
\note{
If no parameters are included, the user is prompted for input. If partial
parameters, the default parameter values are used for those not specified.
}
\examples{
\dontrun{
# Most current evaluation and shapefile with public coordinates
COxylst <- DBgetXY(states = "Colorado",
                   measCur = TRUE)
names(COxylst)

head(COxylst$xyCur_ACTUAL)
COxylst$xyqry
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
