% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datFreq.R
\name{datFreq}
\alias{datFreq}
\title{Data - Get frequency table for specified variable(s).}
\usage{
datFreq(
  x,
  xvar = NULL,
  total = FALSE,
  subtotal = FALSE,
  subtotalcol = NULL,
  savedata = FALSE,
  savedata_opts = NULL,
  gui = FALSE
)
}
\arguments{
\item{x}{Data frame or comma-delimited file (*.csv). The table with the
variable(s).}

\item{xvar}{String (vector).* The name of the variable(s) to summarize.}

\item{total}{Logical. If TRUE, a row is added to bottom of table with a
total for the whole table.}

\item{subtotal}{Logical. If TRUE, a row is added to bottom of each section
for subtotals.}

\item{subtotalcol}{Logical. If subtotal=TRUE, the column(s) to generate
subtotals.}

\item{savedata}{Logical. If TRUE, writes output data to outfolder.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE. If out_layer = NULL,
default = 'datfreq'.}

\item{gui}{Logical. If TRUE, pop-up windows will appear for user-interface.}
}
\value{
\item{freqtable}{ Data frame. The frequency table. } If
savedata=TRUE, a comma-delimited file of the frequency table is written to
the outfolder.
}
\description{
Generates a frequency table from a data frame, including number of records
by a specified variable or variables in the data frame with optional totals
and/or subtotals.
}
\details{
If no parameters, then user is prompted for input. If partial parameters,
default parameter values are used.
}
\examples{
# Set up data for example
tab <- data.frame(cbind(CONDCLASS = c(1, 1, 2, 1, 3, 3, 3, 1, 1, 1, 2, 1), 
		                     FORTYPCD = c(182, 184, 201, 221, 221, 184, 221, 182,
		                                  182, 201, 182, 221)))

# Frequency table with "FORTYPCD"       
datFreq(x = tab,
        xvar = "FORTYPCD")
		                                  
# Frequency table with "CONDCLASS" and "FORTYPCD" 		                                   
datFreq(x = tab,
        xvar = c("CONDCLASS", "FORTYPCD"))

# Frequency table with "CONDCLASS" and "FORTYPCD", adding total and subtotal
# rows 		                                   
datFreq(x = tab,
        xvar = c("CONDCLASS", "FORTYPCD"), 
        total = TRUE, 
        subtotal = TRUE)
        
# Frequency table for WYtree, multiple variables, subtotal options
datFreq(x = FIESTA::WYtree,
        xvar = c("SPGRPCD", "SPCD", "STATUSCD"), 
	       subtotal = TRUE, subtotalcol = "SPCD")
}
\author{
Tracey S. Frescino
}
\keyword{data}
