% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{make.calibration}
\alias{make.calibration}
\title{Creates a calibration object, further used for calculation of coordinates in the \code{\link{run.particle.filter}}.}
\usage{
make.calibration(
  Proc.data,
  Calibration.periods,
  model.ageing = FALSE,
  plot.each = FALSE,
  plot.final = FALSE,
  likelihood.correction = "auto",
  fixed.logSlope = c(NA, NA),
  suggest.irrad.borders = FALSE,
  return.slopes = FALSE
)
}
\arguments{
\item{Proc.data}{processed data object generated by \code{\link{get.tags.data}}}

\item{Calibration.periods}{a data frame containing start and end dates of all the calibration periods (POSIXct) and geographic coordinates of the corresponding calibration locations.}

\item{model.ageing}{if set to TRUE, accounts for the tag ageing (with opacification of its transparent shell of a light sensor), resulting into decreasing sensitivity of the device. This option is useful only if there were several calibration periods or if calibration period was very long (~ longer than a month).}

\item{plot.each}{Do you want every twilight to be plotted while processing}

\item{plot.final}{Do you want final calibration graph to be plotted. On the graph you can see all the observed versus expected light levels. All slopes should be similar.}

\item{likelihood.correction}{will estimate correction of likelihood for the current calibration parameters. Highly recommended not to be change from 'auto'. In this case FLightR will switch it to FALSE in case tag saved dat on 10 minutes or longer period.}

\item{fixed.logSlope}{these are mean (1) and SD (2) for distribution of slopes. Should normally be estimated from the data (and thus default is c(NA, NA)). Change any of these two finite values if you want them to be predetermined and not estimated from the calibration data.}

\item{suggest.irrad.borders}{experimental parameter! If set to TRUE function will try to find the best values for the log.irrad.borders}

\item{return.slopes}{if true function will return estimated individual twilight slopes.}
}
\description{
Function estimates all necessary parameters from the calibration data logged in a known location or locations.
}
\examples{
File<-system.file("extdata", "Godwit_TAGS_format.csv", package = "FLightR")
Proc.data<-get.tags.data(File, end.date=as.POSIXct('2013-08-20', tz='GMT'))
Calibration.periods<-data.frame(
       calibration.start=NA,
       calibration.stop=as.POSIXct("2013-08-20"),
       lon=5.43, lat=52.93) 
       #use c() also for the geographic coordinates, if you have more than one calibration location
       # (e. g.,  lon=c(5.43, 6.00), lat=c(52.93,52.94))
print(Calibration.periods)

# NB Below likelihood.correction is set to FALSE for fast run! 
# Leave it as default 'auto' for real examples
Calibration<-make.calibration(Proc.data, Calibration.periods, likelihood.correction=FALSE)

}
\author{
Eldar Rakhimberdiev
}
