#' @title Catch and effort data for South Indian Ocean Jobfish.
#' 
#' @description Catch and effort data for Jobfish (\emph{Pristipomoides filamentosus}) from the South Indian Ocean.
#' 
#' @name JobfishSIO
#' 
#' @docType data
#' 
#' @format A data frame with 13 observations on the following 2 variables.
#'  \describe{
#'    \item{catch}{Catches (kg).} 
#'    \item{effort}{Effort (man-hours).} 
#'  }
#'  
#' @section Topic(s):
#'  \itemize{
#'    \item Population size 
#'    \item Abundance 
#'    \item Depletion methods 
#'    \item Leslie method
#'    \item DeLury method 
#'    \item Catchability
#'  }
#' 
#' @concept Abundance 'Population Size' Leslie DeLury Depletion Catchability
#' 
#' @source From Table 2 of Grandcourt, E.M.  2003.  \href{http://fishbull.noaa.gov/1012/08grandc.pdf}{The effect of intensive line fishing on the virgin biomass of a tropical deepwater snapper, the crimson jobfish (\emph{Pristipomoides filamentosus})}. Fisheries Bulletin, 101:305-311.
#' 
#' @keywords datasets
#' 
#' @examples
#' data(JobfishSIO)
#' str(JobfishSIO)
#' head(JobfishSIO)
#' 
NULL