% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarmTest.R
\name{farm.fdr}
\alias{farm.fdr}
\title{FDR control given a sequence of p-values}
\usage{
farm.fdr(pValues, alpha = 0.05)
}
\arguments{
\item{pValues}{A sequence of p-values, each entry of \code{pValues} must be between 0 and 1.}

\item{alpha}{An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be strictly between 0 and 1. The default value is 0.05.}
}
\value{
Indices of tests that are rejected will be returned. It will show "no hypotheses rejected" if none of the tests are rejected.
}
\description{
Given a sequence of p-values, this function conducts multiple testing and outputs the indices of rejected hypotheses using an adaptive Benjamini-Hochberg procedure proposed by Storey (2002).
}
\examples{
set.seed(100)
n = 50
p = 100
X = cbind(matrix(rnorm(n * 10, 1, 1), n, 10), matrix(rnorm(n * (p - 10)), n, p - 10))
pValues = apply(X, 2, function(x) t.test(x)$p.value)
farm.fdr(pValues)
}
\references{
Benjamini, Y. and Hochberg, Y. (1995). Controlling the false discovery rate: A practical and powerful approach to multiple testing. J. R. Stat. Soc. Ser. B. Stat. Methodol. 57 289–300.

Storey, J. D. (2002). A direct approach to false discovery rates. J. R. Stat. Soc. Ser. B. Stat. Methodol. 64, 479–498.
}
\seealso{
\code{\link{farm.test}}
}
