% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jmcs.R
\name{plot.jmcs}
\alias{plot.jmcs}
\title{Fitted values for joint models}
\usage{
\method{plot}{jmcs}(x, add.smooth = getOption("add.smooth"), ...)
}
\arguments{
\item{x}{x of class 'jmcs'.}

\item{add.smooth}{logical; if \code{TRUE} a smooth line is superimposed in the "Residuals vs Fitted" plot.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The first two plots are longitudinal sub-model diagnostics and the last two are marginal survival function and marginal cumulative hazard.
}
\description{
Plot Diagnostics for Joint Models.
}
\examples{
\donttest{
fit <- jmcs(ydata = ydata, cdata = cdata, 
            long.formula = response ~ time + gender + x1 + race, 
            surv.formula = Surv(surv, failure_type) ~ x1 + gender + x2 + race, 
            random =  ~ time| ID)

oldpar <- par(mfrow = c(2, 2))
plot(fit)
par(oldpar)
}

}
\author{
Shanpeng Li \email{lishanpeng0913@ucla.edu}
}
