% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{tidyCovariateData}
\alias{tidyCovariateData}
\title{Tidy covariate data}
\usage{
tidyCovariateData(
  covariateData,
  minFraction = 0.001,
  normalize = TRUE,
  removeRedundancy = TRUE
)
}
\arguments{
\item{covariateData}{An object as generated using the \code{\link{getDbCovariateData}}
function.}

\item{minFraction}{Minimum fraction of the population that should have a non-zero value for a
covariate for that covariate to be kept. Set to 0 to don't filter on
frequency.}

\item{normalize}{Normalize the covariates? (dividing by the max).}

\item{removeRedundancy}{Should redundant covariates be removed?}
}
\value{
An object of class \code{CovariateData}.
}
\description{
Tidy covariate data
}
\details{
Normalize covariate values by dividing by the max and/or remove redundant covariates and/or remove
infrequent covariates. For temporal covariates, redundancy is evaluated per time ID.
}
\examples{
\donttest{
covariateData <- FeatureExtraction::createEmptyCovariateData(
  cohortIds = 1,
  aggregated = FALSE,
  temporal = FALSE
)

covData <- tidyCovariateData(
  covariateData = covariateData,
  minFraction = 0.001,
  normalize = TRUE,
  removeRedundancy = TRUE
)
}

}
