% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FiSh.R
\docType{package}
\name{FiSh-package}
\alias{FiSh}
\alias{FiSh-package}
\title{FiSh: Fisher-Shannon Method}
\description{
Proposes non-parametric estimates of the Fisher information measure and the 
              Shannon entropy power. The state-of-the-art studies related to the Fisher-Shannon 
              measures, with new analytical formulas for positive unimodal skewed distributions 
              are presented in Guignard et al. <arXiv:1912.02452>. A 'python' version of this 
              work is available on 'github' and 'PyPi' ('FiShPy').
}
\details{
This R code was developed and used for the following paper:

F. Guignard, M. Laib, F. Amato, M. Kanevski, Advanced analysis of temporal data using Fisher-Shannon information:
theoretical development and application in geosciences, \href{https://arxiv.org/abs/1912.02452}{arXiv:1912.02452}.
}
\references{
S. J. Sheather and M. C. Jones (1991). A reliable data-based bandwidth selection method for kernel density
estimation. Journal of the Royal Statistical Society, Series B, 53, 683 - 690.

M. P. Wand and M. C. Jones (1995). Kernel Smoothing. Chapman and Hall, London.

C. Vignat, J.F Bercher (2003). Analysis of signals in the Fisher–Shannon information plane, Physics Letters A,
312, 190, 27 – 33.

F. Guignard, M. Laib, F. Amato, M. Kanevski, Advanced analysis of temporal data using Fisher-Shannon information:
theoretical development and application in geosciences, \href{https://arxiv.org/abs/1912.02452}{arXiv:1912.02452}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://FiShInfo.github.io/}
}

}
\author{
Fabian Guignard \email{fabian.guignard@bluemail.ch} and

Mohamed Laib \email{laib.med@gmail.com}

Maintainer: Mohamed Laib \email{laib.med@gmail.com}
}
