% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_rectangular_lattice.R
\name{rectangular_lattice}
\alias{rectangular_lattice}
\title{Generates a Rectangular Lattice Design.}
\usage{
rectangular_lattice(
  t = NULL,
  k = NULL,
  r = NULL,
  l = 1,
  plotNumber = 101,
  locationNames = NULL,
  seed = NULL,
  data = NULL
)
}
\arguments{
\item{t}{Number of  treatments.}

\item{k}{Size of incomplete blocks (number of units per incomplete block).}

\item{r}{Number of blocks (full resolvable replicates).}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{locationNames}{(optional) Names for each location.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with label list of treatments.}
}
\value{
A list with two elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{fieldBook} is a data frame with the rectangular lattice design field book.
}
}
\description{
It randomly generates a rectangular lattice design across locations.
}
\examples{
# Example 1: Generates a rectangular lattice design with 6 full blocks, 4 units per IBlock (k)
# and 20 treatments in one location.
rectangularLattice1 <- rectangular_lattice(t = 20, k = 4, r = 6, l = 1, 
                                           plotNumber = 101,
                                           locationNames = "FARGO", 
                                           seed = 126)
rectangularLattice1$infoDesign
head(rectangularLattice1$fieldBook,12)

# Example 2: Generates a rectangular lattice design with 5 full blocks, 7 units per IBlock (k)
# and 56 treatments across 2 locations.
# In this case, we show how to use the option data.
treatments <- paste("ND-", 1:56, sep = "")
ENTRY <- 1:56
treatment_list <- data.frame(list(ENTRY = ENTRY, TREATMENT = treatments))
head(treatment_list) 
rectangularLattice2 <- rectangular_lattice(t = 56, k = 7, r = 5, l = 2, 
                                           plotNumber = c(1001,2001),
                                           locationNames = c("Loc1", "Loc2"), 
                                           seed = 127,
                                           data = treatment_list)
rectangularLattice2$infoDesign
head(rectangularLattice2$fieldBook,12)

}
\references{
Edmondson., R. N. (2021). blocksdesign: Nested and crossed block designs for factorial and
unstructured treatment sets. https://CRAN.R-project.org/package=blocksdesign
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
