% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compound_symmetry_gxe.R
\name{compsym_asr_input}
\alias{compsym_asr_input}
\title{Genetic values based on a compound symmetry model for GxE interaction using 'AlphaSimR' - Input
parameters}
\usage{
compsym_asr_input(
  n_envs,
  n_traits,
  mean,
  var,
  rel_main_eff_A,
  cor_A = NULL,
  mean_DD = NULL,
  var_DD = NULL,
  rel_main_eff_DD = NULL,
  cor_DD = NULL,
  rel_AA = NULL,
  rel_main_eff_AA = NULL,
  cor_AA = NULL
)
}
\arguments{
\item{n_envs}{Number of environments to be simulated. A minimum of two environments is required.}

\item{n_traits}{Number of traits to be simulated.}

\item{mean}{A vector of mean genetic values for each trait-by-environment combination (ordered
as environments within traits). Simulated traits can have a different mean for each
environment. If the length of \code{mean} corresponds to \code{n_traits}, all traits will be
assigned the same mean for each environment.}

\item{var}{A vector of genetic variances for each trait. Simulated traits are restricted by the
compound symmetry model to having the same variance for each environment (i.e., main
effect variance + GxE interaction variance) and the same covariance between each pair of
environments (main effect variance). \cr
\strong{Note:} when \code{useVarA = TRUE} is specified in 'AlphaSimR' (default) the values in
\code{var} represent the \code{additive} genetic variances, otherwise they will represent the
\code{total} (additive + non-additive) genetic variances.}

\item{rel_main_eff_A}{A vector defining the magnitude of the additive main effect variance
relative to the additive main effect + GxE interaction variance for each trait. If only one
value is provided and \code{n_traits > 1}, all traits will be assigned the same value. \cr
\strong{Note:} \code{0 < rel_main_eff_A < 1}.}

\item{cor_A}{A matrix of additive genetic correlations between more than one trait. If not
defined and \code{n_traits > 1}, a diagonal matrix is constructed.}

\item{mean_DD}{A vector of mean dominance degrees for each trait-by-environment combination
(ordered as environments within traits), similar to \code{mean}. By default,
\code{mean_DD = NULL} and dominance is not simulated.}

\item{var_DD}{A vector of dominance degree variances for each trait. Simulated traits have the
same dominance degree variance for each environment and the same dominance degree covariance
between each pair of environments (similar to \code{var}). By default, \code{var_DD = NULL}.}

\item{rel_main_eff_DD}{A vector defining the magnitude of the dominance degree main effect
variance relative to the main effect + GxE interaction variance for each trait (similar to
\code{rel_main_eff_A}) \cr
\strong{Note:} \code{0 < rel_main_eff_DD < 1}. By default, \code{rel_main_eff_DD = NULL}.}

\item{cor_DD}{A matrix of dominance degree correlations between more than one trait (similar
to \code{cor_A}). If not defined and \code{n_traits > 1}, a diagonal matrix is constructed.
By default, \code{cor_DD = NULL}.}

\item{rel_AA}{A vector defining the magnitude of additive-by-additive (epistatic) variance
relative to the additive genetic variance for each trait, that is in a diploid organism with
allele frequency 0.5. Simulated traits have the same epistatic variance for each environment
and the same epistatic covariance between each pair of environments (similar to \code{var}).
By default, \code{rel_AA = NULL} and epistasis is not simulated.}

\item{rel_main_eff_AA}{A vector defining the magnitude of the epistatic main effect variance
relative to the main effect + GxE interaction variance for each trait (similar to
\code{rel_main_eff_A}). \cr
\strong{Note:} \code{0 < rel_main_eff_AA < 1}. By default, \code{rel_main_eff_AA = NULL}.}

\item{cor_AA}{A matrix of epistatic correlations between more than one trait (similar to
\code{cor_A}). If not defined and \code{n_traits > 1}, a diagonal matrix is constructed. By
default, \code{cor_AA = NULL}.}
}
\value{
A list containing input parameters for 'AlphaSimR', which is used to simulate
  correlated genetic effects based on a compound symmetry model.
}
\description{
Creates a list of input simulation parameters for
\href{https://CRAN.R-project.org/package=AlphaSimR}{'AlphaSimR'} to simulate
genetic values for multiple traits in multiple environments based on a compound symmetry model
for genotype-by-environment (GxE) interaction. \cr
By default, 'AlphaSimR' does not support complex models for GxE interaction. However, its
functionality to simulate correlated genetic values can be utilised for this purpose by
providing the required variance structures. \code{compsym_asr_input} is a wrapper function to
construct the variance structures required to simulate GxE interaction in 'AlphaSimR' based on
a compound symmetry model. This function assumes a separable structure between traits and
environments. It is also used in combination with the wrapper function
\link[FieldSimR]{compsym_asr_output}.
}
\details{
\strong{Note:} 'AlphaSimR' can simulate different biological effects (see:
\code{\link[AlphaSimR]{SimParam}}).
\itemize{
  \item For additive traits use \code{addTraitA()}.
  \item For additive + dominance traits use \code{addTraitAD()}.
  \item For additive + epistatic traits use \code{addTraitAE()}.
  \item For additive + dominance + epistatic traits use \code{addTraitADE()}.
  }
If non-additive effects are to be simulated, check the \code{useVarA} argument of these
functions.
}
\examples{
# Simulation of genetic values in 'AlphaSimR' for two additive + dominance traits tested in
# three environments based on a compound symmetry model for GxE interaction.

# 1. Define the genetic architecture of the simulated traits.
# Mean genetic values and mean dominance degrees for trait 1 in all 3 environments and trait 2
# in all 3 environments.
mean <- c(1, 3, 2, 80, 70, 100) # Trait 1 x 3 environments, trait 2 x 3 environments.
mean_DD <- c(0.1, 0.4) # Trait 1 and 2, same values set in 3 environments for each trait.

# Additive genetic variances (useVarA = TRUE) and dominance degree variances for traits 1 and 2.
var <- c(0.2, 10)
var_DD <- c(0.1, 0.2)

# Relative magnitude of the additive and dominance degree main effect variance for traits 1 and 2.
rel_main_eff_A <- c(0.4, 0.6) # Different values set for traits 1 and 2.
rel_main_eff_DD <- 0.8 # Same value set for traits 1 and 2.

# Additive and dominance degree correlations between traits 1 and 2.
cor_A <- matrix(c(1.0, 0.3, 0.3, 1.0), ncol = 2) # Additive correlation matrix.
cor_DD <- diag(2) # Assuming independence between traits.

input_asr <- compsym_asr_input(
  n_envs = 3,
  n_traits = 2,
  mean = mean,
  var = var,
  rel_main_eff_A = rel_main_eff_A,
  cor_A = cor_A,
  mean_DD = mean_DD,
  var_DD = var_DD,
  rel_main_eff_DD = rel_main_eff_DD,
  cor_DD = cor_DD
)
}
