% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\docType{class}
\name{fis}
\alias{fis}
\title{fis class}
\description{
The fis class is the main class (Rcpp class) to open and use a Fuzzy Inference System.
}
\section{Fields}{

\describe{
\item{\code{name}}{the name of the FIS.}

\item{\code{input_size}}{the number of inputs in the FIS.}

\item{\code{output_size}}{the number of outputs in the FIS.}
}}

\section{Methods}{

\describe{
\item{constructor}{argument: \code{fis_file} a FIS configuration file (can be built with FisPro software \url{https://www.fispro.org}). \cr return: an object of fis.}
\item{infer}{infers a value for each output from the input values \cr argument: \code{values} numerical vector of input values. \cr return: all infered outputs.}
\item{infer_output}{infers a value for a single output from the input values \cr argument: \code{values} numerical vector of input values. \cr argument: \code{output_number} the number of the output to infer. \cr return: the infered output.}
}
}

\examples{
# build the FIS
fis_file <- system.file("extdata", "test.fis", package = "FisPro")
fis <- new(fis, fis_file)

# infer all outputs
infered <- fis$infer(c(0.25, 0.75))
#infer first output
infered_output1 <- fis$infer_output(c(0.25, 0.75), 0)
#infer second output
infered_output2 <- fis$infer_output(c(0.25, 0.75), 1)

}
\references{
{
  \href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
}
}
