% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisout.R
\docType{class}
\name{FisOutCrisp}
\alias{FisOutCrisp}
\title{Class "FisOutCrisp"}
\description{
Class to manage a \link{Fis} crisp output
}
\section{Fields}{

\describe{
\item{\code{defuzzification}}{\link{character} vector, The defuzzification operator of the crisp output\cr
Allowed values are: "sugeno" (the default) or "MaxCrisp"\cr}

\item{\code{disjunction}}{\link{character} vector, The disjunction operator of the crisp output\cr
Allowed values are: "max" (the default) or "sum"\cr}
}}

\section{Inherits}{

\link{FisOutCrisp} class inherits all fields and methods of \link{FisOut} class
}

\section{Constructors}{

\describe{
\item{\code{FisOutCrisp()}}{
The default constructor to build a crisp output with the default range [0, 1]
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{FisOutCrisp} object}
}}

\item{\code{FisOutCrisp(minimum, maximum)}}{
The constructor to build a crisp output
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{minimum}}{\link{numeric} value, The minimum range value of the output}
\item{argument: \code{maximum}}{\link{numeric} value, The maximum range value of the output}
\item{return:}{\link{FisOutCrisp} object}
}}}
}

\examples{
output <- NewFisOutCrisp(0, 1)
output$name <- "foo"
output$defuzzification <- "sugeno"
output$disjunction <- "max"
}
\seealso{
{
\link{NewFisOutCrisp}

\href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
}
}
