modpar <-
structure(function
		(x,
                     y,
                     first.y = NA,
                     x.at.first.y = NA,
                     last.y = NA,
                     x.at.last.y = NA,
                     twocomponent.x = NA,
                     verbose = FALSE,
                     force8par = FALSE,
                     force4par = FALSE,
                     pn.options = NA
                     ) {
    options(warn = -1)
    assign(".paramsestimated", FALSE, envir = globalenv())
    if(!is.na(pn.options)) {
    pnopt<- as.character( pn.options[1] ) 
    } else {
    pnopt<- ".pntemplist"
    }
    pnoptnm <- pnopt
    if(!is.na(twocomponent.x) & force4par == TRUE) 
    	stop("Cannot force a two component Richards model to have a single component.Set force4par to FALSE")
    prntqut<-function(tx) print(noquote(tx))
    prntqut("modpar will attempt to parameterize your data using the following sequential procedures:")
    prntqut("  (1) Extract parameter estimates for 8-parameter double-Richards curve in nls")
    prntqut("  (2) Use getInitial to retrieve parameter estimates for 8-parameter double-Richards curve")
    prntqut("  (3) Extract parameter estimates for 4-parameter Richards curve in nls")
    prntqut("  (4) Use getInitial to retrieve parameter estimates for 4-parameter Richards curve")
    prntqut("if any approaches are successful, modpar will return these and terminate at that stage")
    prntqut(" ")
    detl <- TRUE
    if(verbose == TRUE) detl <- FALSE
    skel <- rep(list(1), 15)
    initval <- c(rep(NA, 15))
    initval <- relist(initval, skel)
    names(initval) <- c("Asym", "K", "Infl", "M", "RAsym", "Rk",
        "Ri", "RM", "first.y", "x.at.first.y", "last.y", "x.at.last.y",
        "twocomponent.x","verbose","force4par")
    initval$first.y <- first.y
    initval$x.at.first.y <- x.at.first.y
    initval$last.y <- last.y
    initval$x.at.last.y <- x.at.last.y
    initval$twocomponent.x <- twocomponent.x
    initval$verbose <- verbose
    initval$force4par <- force4par
    skel1 <- rep(list(1), 16)
    initval1 <- c(rep(NA, 16))
    initval1 <- relist(initval1, skel1)
    names(initval1) <- c("Amin", "Amax", "Kmin", "Kmax", "Imin",
        "Imax", "Mmin", "Mmax", "RAmin", "RAmax", "Rkmin", "Rkmax",
        "Rimin", "Rimax", "RMmin", "RMmax")
    formtassign <- function (x,y,type=0) {    
    	valexp <- sapply( c( unlist(x),unlist(y) ) 
   		 , function(x) list(x))
    	names( valexp[1:31] ) <- names( c(x,y) )
    	valexp[1:31] <- as.numeric( valexp[1:31] )
    	valexp[13:15] <- as.logical( valexp[13:15] )
    	if(type == 1) {
    		return(valexp[1:15])
    	} else {
    		if(type == 2) {
    			return(valexp[16:31])
    		}  else {
    		return(valexp)
    		}
    		      }
    		      			 }
    parseval <- function(txt1,evtxt,txt2) {
    callout<- parse(text=sprintf("%s",paste(txt1,as.character(evtxt),txt2,sep="")))
    return(eval(callout))
    					  }
    valexp <- formtassign(initval, initval1)
    assign(pnopt, valexp, .GlobalEnv)
    xy <- data.frame(x, y)
    xy <- na.omit(xy)
    evlfit<-function(val1,val2){
 	richards <- function(x, Asym, K, Infl, M) Asym/Re(as.complex(1 +
    	    M * exp(-K * (x - Infl)))^(1/M))
	 SSposnegRichardsF <- function(x, Asym, K, Infl, M, RAsym,
  	      Rk, Ri, RM) (Asym/Re(as.complex(1 + M * exp(-K * (x -
  	      Infl)))^(1/M))) + (RAsym/Re(as.complex(1 + RM * exp(-Rk *
  	      (x - Ri)))^(1/RM)))
	if(is.na(val1[5])){
		evl1<- sum((y-richards(x,as.numeric(val1[1]),as.numeric(val1[2]),
               	 as.numeric(val1[3]),as.numeric(val1[4])))^2)
		evl2<- sum((y-richards(x,as.numeric(val2[1]),as.numeric(val2[2]),
               	 as.numeric(val2[3]),as.numeric(val2[4])))^2)

	}else{
		evl1<- sum((y-SSposnegRichardsF(as.numeric(x),as.numeric(val1[1]),as.numeric(val1[2]),
               	 as.numeric(val1[3]),as.numeric(val1[4]),
		as.numeric(val1[5]),as.numeric(val1[6]),
		as.numeric(val1[6]),as.numeric(val1[8])))^2)
		evl2<- sum((y-SSposnegRichardsF(x,as.numeric(val2[1]),as.numeric(val2[2]),
               	 as.numeric(val2[3]),as.numeric(val2[4]),
		as.numeric(val2[5]),as.numeric(val2[6]),
		as.numeric(val2[6]),as.numeric(val2[8])))^2)
	}
	if(evl1<=evl2) {
	valfin<-val1
	}else{
	valfin<-val2
	}
	return(valfin)
	}
    value <- NA
    succ <- FALSE
    if(force4par == TRUE & is.na(twocomponent.x)) {
      value <- parseval("try(getInitial(y ~ SSposnegRichards(x, Asym = Asym,
    	             K = K, Infl = Infl, M = M, modno = 19, pn.options =",  pnoptnm,"), data = xy), silent = detl)")
            savvalue<-value
            value<-NA
    prntqut("(3) Status of 4-parameter Richards curve nls fit:")
    try({ value <- parseval("coef(nls(y ~ SSposnegRichards(x, Asym = Asym,
                    K = K, Infl = Infl, M = M, modno = 19, pn.options =",  pnoptnm,"), data = xy))")
         		}, silent = detl)
         if(is.na(value[1]) == FALSE & class(value)[1] != "try-error") prntqut("4 parameter nls fit successful")
         if(is.na(value[1]) == TRUE | class(value)[1] == "try-error") {
          prntqut("....4-parameter nls fit failed")
          prntqut("(4) Status of 4-parameter Richards getInitial call:")
         value <- parseval("try(getInitial(y ~ SSposnegRichards(x, Asym = Asym,
	             K = K, Infl = Infl, M = M, modno = 19, pn.options =",  pnoptnm,"), data = xy), silent = detl)")
            if(is.na(value[1]) == TRUE | class(value)[1] == "try-error") {
            stop("estimates not available for data provided. Please check data, call or provide estimates manually, see ?modpar")
            assign(".paramsestimated", FALSE, envir = globalenv())
 
         					} else {
         					prntqut("....4 parameter getInitial successful")
         					}
         }
  if(!is.na(value[1]) & class(value)[1] != "try-error" & !is.na(savvalue[1]) & class(savvalue)[1] != "try-error") value<-evlfit(savvalue,value)
    }else{
    if(detl == TRUE) prntqut("Estimating parameter bounds....")
    value <- parseval("try(getInitial(y ~ SSposnegRichards(x, Asym = Asym,
                K = K, Infl = Infl, M = M, RAsym = RAsym, Rk = Rk,
            Ri = Ri, RM = RM, modno = 18, pn.options =",  pnoptnm,"), data = xy), silent = detl)")
            tst<- get(pnoptnm, .GlobalEnv)[16:31]
     if (is.na(value[1]) == TRUE | class(value)[1] == "try-error"){
        value <- parseval("try(getInitial(y ~ SSposnegRichards(x, Asym = Asym,
         	             K = K, Infl = Infl, M = M, modno = 19, pn.options =",  pnoptnm,"), data = xy), silent = detl)")
            bndsvals<-get(pnoptnm, .GlobalEnv) [16:31]
            bndsvals[9:16]<-bndsvals[1:8]
            valexp <- formtassign( initval , bndsvals)				  
	    assign(pnoptnm, valexp, .GlobalEnv)  
            			} else {
            valexp <- formtassign( initval , tst)				  
	    assign(pnoptnm, valexp, .GlobalEnv)			
            			}
         savvalue<-value
         value<-NA
    if(force4par == TRUE & !is.na(twocomponent.x)) prntqut("Cannot force a two component model to have 4 parameters")
    prntqut("(1) Status of 8-parameter double-Richards curve fit in nls:")
    value <- parseval("try(coef(nls(y ~ SSposnegRichards(x, Asym = Asym,
        K = K, Infl = Infl, M = M, RAsym = RAsym, Rk = Rk, Ri = Ri,
        RM = RM, modno = 18, pn.options =",  pnoptnm,"), data = xy)), silent = detl)")  
    if (is.na(value[1]) == TRUE | class(value)[1] == "try-error") {
        prntqut("....8 parameter nls fit failed")
        prntqut("(2) Status of 8-parameter double-Richards getInitial call")
        value <- parseval("try(getInitial(y ~ SSposnegRichards(x, Asym = Asym,
            K = K, Infl = Infl, M = M, RAsym = RAsym, Rk = Rk,
            Ri = Ri, RM = RM, modno = 18, pn.options =",  pnoptnm,"), data = xy), silent = detl)")
             if (is.na(value[1]) == FALSE & class(value)[1] != "try-error") {
             		succ <- TRUE
             		prntqut("....8-parameter getInitial successful")
             		}
    } else {
        prntqut("....8-parameter nls fit successful")
        succ <- TRUE
    }
    if(!is.na(value[1]) & class(value)[1] != "try-error" & !is.na(savvalue[1]) & class(savvalue)[1] != "try-error") value<-evlfit(savvalue,value)
    if ((is.na(value[1]) == TRUE & is.na(twocomponent.x)) | (class(value)[1] == "try-error" & is.na(twocomponent.x)) ) {
        prntqut("(3) Status of 4-parameter Richards curve nls fit:")
        prntqut("if force8par==TRUE second curve parameters estimated as RAsym=Asym*0.05, Rk=K, Ri=Infl, RM=M")
        try({
            value <- parseval("coef(nls(y ~ SSposnegRichards(x, Asym = Asym,
                K = K, Infl = Infl, M = M, modno = 19, pn.options =",  pnoptnm,"), data = xy))")
            if (force8par == TRUE) {
                value <- c(value, value[1] * 0.05, value[2],
                  value[3], value[4])
                names(value) <- c("Asym", "K", "Infl", "M", "RAsym",
                  "Rk", "Ri", "RM")
            }
        }, silent = detl)
        if(is.na(value[1]) == TRUE | class(value)[1] == "try-error") {
          prntqut("....4-parameter nls fit failed")
          prntqut("(4) Status of 4-parameter Richards getInitial call:")
          try({
 	    value <- parseval("getInitial(y ~ SSposnegRichards(x, Asym = Asym,
	             K = K, Infl = Infl, M = M, modno = 19, pn.options =",  pnoptnm,"), data = xy)")
	    if (force8par == TRUE) {
	        value <- c(value, value[1] * 0.05, value[2],
	          value[3], value[4])
	        names(value) <- c("Asym", "K", "Infl", "M", "RAsym",
	        "Rk", "Ri", "RM")
	     }
          }, silent = detl)
          if(is.na(value[1]) == TRUE | class(value)[1] == "try-error") prntqut("....4 parameter getInitial failed")
        } else {
        prntqut("....4 parameter nls successful")
        }
        if(is.na(value[1]) == TRUE | class(value)[1] == "try-error")
            stop("**Estimates not available for data provided**. Please check data or provide estimates manually, see ?modpar")
    } else {
         if (succ != TRUE)
                  stop("**Estimates not available for data provided**. Please check data or provide estimates manually, see ?modpar")
    }
    }
    if (length(value) == 4) {
        value <- c(value, rep(NA, 4))
        names(value) <- c(names(value[1:4]), "RAsym", "Rk", "Ri",
            "RM")
    }
    optvals <- c(first.y, x.at.first.y, last.y, x.at.last.y, twocomponent.x, verbose, force4par)
    names(optvals) <- c("first.y", "x.at.first.y", "last.y", "x.at.last.y", "twocomponent.x", "verbose", "force4par")
    value <- c(unlist(value), optvals)
    skel <- rep(list(1), 15)
    value1 <- relist(value, skel)
    names(value1) <- c("Asym", "K", "Infl", "M", "RAsym", "Rk",
        "Ri", "RM", "first.y", "x.at.first.y", "last.y", "x.at.last.y",
        "twocomponent.x", "verbose", "force4par")
    lodpar <- get(pnoptnm, .GlobalEnv) [1:15]
    value1$twocomponent.x <- lodpar$twocomponent.x
    value1$verbose <- initval$verbose
    value1$force4par <- initval$force4par
    valexp <- formtassign( value1 , get(pnoptnm, .GlobalEnv) [16:31]) 				  
    assign(pnoptnm, valexp, .GlobalEnv)
    pnmodelparams <- value1
    Amax = pnmodelparams$Asym + (abs(pnmodelparams$Asym) * 2.5)
    Amin = pnmodelparams$Asym - (abs(pnmodelparams$Asym) * 0.5)
    Kmax = pnmodelparams$K + (abs(pnmodelparams$K) * 0.5)
    Kmin = pnmodelparams$K - (abs(pnmodelparams$K) * 0.5)
    Imax = pnmodelparams$Infl + (abs(pnmodelparams$Infl) * 10)
    Imin = pnmodelparams$Infl + (abs(pnmodelparams$Infl) * -2.5)
    while (abs(Imax * Kmax) > 700) Imax = Imax * 0.9
    while (abs(Imin * Kmax) > 700) Imin = Imin * 0.9
    Mmax = pnmodelparams$M + abs(pnmodelparams$M * 2)
    Mmin = pnmodelparams$M - abs(pnmodelparams$M * 2)
    if (is.na(pnmodelparams$RAsym)) {
        pnmodelparams$RAsym <- pnmodelparams$Asym
        pnmodelparams$Rk <- pnmodelparams$K
        pnmodelparams$Ri <- pnmodelparams$Infl
        pnmodelparams$RM <- pnmodelparams$M
    }
    RAmax = pnmodelparams$RAsym + (abs(pnmodelparams$RAsym) *
        2.5)
    RAmin = pnmodelparams$RAsym - (abs(pnmodelparams$RAsym) *
        0.5)
    Rkmax = pnmodelparams$Rk + (abs(pnmodelparams$Rk) * 0.5)
    Rkmin = pnmodelparams$Rk - (abs(pnmodelparams$Rk) * 0.5)
    Rimax = pnmodelparams$Ri + (abs(pnmodelparams$Ri) * 5)
    Rimin = pnmodelparams$Ri + (abs(pnmodelparams$Ri) * -2.5)
    while (abs(Rimax * Rkmax) > 700) Rimax = Rimax * 0.9
    while (abs(Rimin * Rkmax) > 700) Rimin = Rimin * 0.9
    RMmax = pnmodelparams$RM + abs(pnmodelparams$RM * 2)
    RMmin = pnmodelparams$RM - abs(pnmodelparams$RM * 2)
    value2 <- c(Amin, Amax, Kmin, Kmax, Imin, Imax, Mmin, Mmax,
        RAmin, RAmax, Rkmin, Rkmax, Rimin, Rimax, RMmin, RMmax)
    skel1 <- rep(list(1), 16)
    value3 <- relist(value2, skel1)
    names(value3) <- c("Amin", "Amax", "Kmin", "Kmax", "Imin",
        "Imax", "Mmin", "Mmax", "RAmin", "RAmax", "Rkmin", "Rkmax",
        "Rimin", "Rimax", "RMmin", "RMmax")
    valexp <- formtassign( value1, value3) 				  
    assign(pnoptnm, valexp, .GlobalEnv)  
    options(warn = 0)
    assign(".paramsestimated", TRUE, envir = globalenv())
    return(valexp)
    }
, ex = function(){
        data(posneg.data)
        modpar(posneg.data$age,posneg.data$mass)

        modpar(posneg.data$age,posneg.data$mass)
        subdata<-subset(posneg.data, as.numeric(row.names (posneg.data) ) < 53)
        richardsR1.lis<-nlsList(mass~SSposnegRichards(age,Asym=Asym,K=K,
        	Infl=Infl,M=M,RAsym=RAsym,Rk=Rk,Ri=Ri,RM=RM,modno=1, pn.options = "myoptions")
                        ,data=subdata)

})
