// Generated by rstantools.  Do not edit by hand.

/*
    FlexReg is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    FlexReg is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with FlexReg.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_BetaBin_theta_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_BetaBin_theta");
    reader.add_event(84, 82, "end", "model_BetaBin_theta");
    return reader;
}
#include <stan_meta_header.hpp>
class model_BetaBin_theta
  : public stan::model::model_base_crtp<model_BetaBin_theta> {
private:
        int N;
        std::vector<int> n;
        std::vector<int> y;
        int K;
        int H;
        matrix_d X;
        matrix_d Z;
        int link_code_mu;
        int link_prior_beta;
        double hyperprior_beta;
        int link_code_theta;
        int link_prior_psi;
        double hyperprior_psi;
public:
    model_BetaBin_theta(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_BetaBin_theta(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_BetaBin_theta_namespace::model_BetaBin_theta";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            validate_non_negative_index("n", "N", N);
            context__.validate_dims("data initialization", "n", "int", context__.to_vec(N));
            n = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            size_t n_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < n_k_0_max__; ++k_0__) {
                n[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 4;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            y = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "H", "int", context__.to_vec());
            H = int(0);
            vals_i__ = context__.vals_i("H");
            pos__ = 0;
            H = vals_i__[pos__++];
            check_greater_or_equal(function__, "H", H, 1);
            current_statement_begin__ = 7;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,K));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, K);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = K;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("Z", "N", N);
            validate_non_negative_index("Z", "H", H);
            context__.validate_dims("data initialization", "Z", "matrix_d", context__.to_vec(N,H));
            Z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, H);
            vals_r__ = context__.vals_r("Z");
            pos__ = 0;
            size_t Z_j_2_max__ = H;
            size_t Z_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    Z(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "link_code_mu", "int", context__.to_vec());
            link_code_mu = int(0);
            vals_i__ = context__.vals_i("link_code_mu");
            pos__ = 0;
            link_code_mu = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_code_mu", link_code_mu, 1);
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "link_prior_beta", "int", context__.to_vec());
            link_prior_beta = int(0);
            vals_i__ = context__.vals_i("link_prior_beta");
            pos__ = 0;
            link_prior_beta = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_beta", link_prior_beta, 1);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "hyperprior_beta", "double", context__.to_vec());
            hyperprior_beta = double(0);
            vals_r__ = context__.vals_r("hyperprior_beta");
            pos__ = 0;
            hyperprior_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "hyperprior_beta", hyperprior_beta, 0);
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "link_code_theta", "int", context__.to_vec());
            link_code_theta = int(0);
            vals_i__ = context__.vals_i("link_code_theta");
            pos__ = 0;
            link_code_theta = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_code_theta", link_code_theta, 1);
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "link_prior_psi", "int", context__.to_vec());
            link_prior_psi = int(0);
            vals_i__ = context__.vals_i("link_prior_psi");
            pos__ = 0;
            link_prior_psi = vals_i__[pos__++];
            check_greater_or_equal(function__, "link_prior_psi", link_prior_psi, 1);
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "hyperprior_psi", "double", context__.to_vec());
            hyperprior_psi = double(0);
            vals_r__ = context__.vals_r("hyperprior_psi");
            pos__ = 0;
            hyperprior_psi = vals_r__[pos__++];
            check_greater_or_equal(function__, "hyperprior_psi", hyperprior_psi, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 20;
            validate_non_negative_index("beta", "K", K);
            num_params_r__ += K;
            current_statement_begin__ = 21;
            validate_non_negative_index("psi", "H", H);
            num_params_r__ += H;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_BetaBin_theta() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 20;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "K", K);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(K);
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 21;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        validate_non_negative_index("psi", "H", H);
        context__.validate_dims("parameter initialization", "psi", "vector_d", context__.to_vec(H));
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi(H);
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            psi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 20;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(K, lp__);
            else
                beta = in__.vector_constrain(K);
            current_statement_begin__ = 21;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.vector_constrain(H, lp__);
            else
                psi = in__.vector_constrain(H);
            // transformed parameters
            current_statement_begin__ = 25;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 26;
            validate_non_negative_index("theta", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(N);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 27;
            validate_non_negative_index("phi", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi(N);
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 30;
            if (as_bool(logical_eq(link_code_mu, 1))) {
                current_statement_begin__ = 31;
                stan::math::assign(mu, inv_logit(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 2))) {
                current_statement_begin__ = 33;
                stan::math::assign(mu, Phi(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 3))) {
                current_statement_begin__ = 35;
                stan::math::assign(mu, inv_cloglog(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 4))) {
                current_statement_begin__ = 37;
                stan::math::assign(mu, stan::math::exp(minus(stan::math::exp(multiply(X, beta)))));
            }
            current_statement_begin__ = 40;
            if (as_bool(logical_eq(link_code_theta, 1))) {
                current_statement_begin__ = 41;
                stan::math::assign(theta, inv_logit(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_theta, 2))) {
                current_statement_begin__ = 43;
                stan::math::assign(theta, Phi(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_theta, 3))) {
                current_statement_begin__ = 45;
                stan::math::assign(theta, inv_cloglog(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_theta, 4))) {
                current_statement_begin__ = 47;
                stan::math::assign(theta, stan::math::exp(minus(stan::math::exp(multiply(Z, psi)))));
            }
            current_statement_begin__ = 49;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 50;
                stan::model::assign(phi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(theta, i, "theta", 1)) / get_base1(theta, i, "theta", 1)), 
                            "assigning variable phi");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 25;
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 26;
            size_t theta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "theta", theta, 0);
            check_less_or_equal(function__, "theta", theta, 1);
            current_statement_begin__ = 27;
            size_t phi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(phi(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: phi" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable phi: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "phi", phi, 0);
            // model body
            current_statement_begin__ = 57;
            for (int l = 1; l <= K; ++l) {
                current_statement_begin__ = 58;
                if (as_bool(logical_eq(link_prior_beta, 1))) {
                    current_statement_begin__ = 59;
                    lp_accum__.add(normal_log<propto__>(get_base1(beta, l, "beta", 1), 0, hyperprior_beta));
                } else if (as_bool(logical_eq(link_prior_beta, 2))) {
                    current_statement_begin__ = 61;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(beta, l, "beta", 1), 0, hyperprior_beta));
                }
            }
            current_statement_begin__ = 64;
            for (int l = 1; l <= H; ++l) {
                current_statement_begin__ = 65;
                if (as_bool(logical_eq(link_prior_psi, 1))) {
                    current_statement_begin__ = 66;
                    lp_accum__.add(normal_log<propto__>(get_base1(psi, l, "psi", 1), 0, hyperprior_psi));
                } else if (as_bool(logical_eq(link_prior_psi, 2))) {
                    current_statement_begin__ = 68;
                    lp_accum__.add(cauchy_log<propto__>(get_base1(psi, l, "psi", 1), 0, hyperprior_psi));
                }
            }
            current_statement_begin__ = 72;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 73;
                lp_accum__.add((((((stan::math::lgamma(get_base1(phi, i, "phi", 1)) - stan::math::lgamma((get_base1(phi, i, "phi", 1) * get_base1(mu, i, "mu", 1)))) - stan::math::lgamma((get_base1(phi, i, "phi", 1) * (1 - get_base1(mu, i, "mu", 1))))) + stan::math::lgamma(((get_base1(phi, i, "phi", 1) * get_base1(mu, i, "mu", 1)) + get_base1(y, i, "y", 1)))) + stan::math::lgamma((((get_base1(phi, i, "phi", 1) * (1 - get_base1(mu, i, "mu", 1))) + get_base1(n, i, "n", 1)) - get_base1(y, i, "y", 1)))) - stan::math::lgamma((get_base1(phi, i, "phi", 1) + get_base1(n, i, "n", 1)))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("psi");
        names__.push_back("mu");
        names__.push_back("theta");
        names__.push_back("phi");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(H);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_BetaBin_theta_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(K);
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi = in__.vector_constrain(H);
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            vars__.push_back(psi(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 25;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 26;
            validate_non_negative_index("theta", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta(N);
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 27;
            validate_non_negative_index("phi", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> phi(N);
            stan::math::initialize(phi, DUMMY_VAR__);
            stan::math::fill(phi, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 30;
            if (as_bool(logical_eq(link_code_mu, 1))) {
                current_statement_begin__ = 31;
                stan::math::assign(mu, inv_logit(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 2))) {
                current_statement_begin__ = 33;
                stan::math::assign(mu, Phi(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 3))) {
                current_statement_begin__ = 35;
                stan::math::assign(mu, inv_cloglog(multiply(X, beta)));
            } else if (as_bool(logical_eq(link_code_mu, 4))) {
                current_statement_begin__ = 37;
                stan::math::assign(mu, stan::math::exp(minus(stan::math::exp(multiply(X, beta)))));
            }
            current_statement_begin__ = 40;
            if (as_bool(logical_eq(link_code_theta, 1))) {
                current_statement_begin__ = 41;
                stan::math::assign(theta, inv_logit(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_theta, 2))) {
                current_statement_begin__ = 43;
                stan::math::assign(theta, Phi(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_theta, 3))) {
                current_statement_begin__ = 45;
                stan::math::assign(theta, inv_cloglog(multiply(Z, psi)));
            } else if (as_bool(logical_eq(link_code_theta, 4))) {
                current_statement_begin__ = 47;
                stan::math::assign(theta, stan::math::exp(minus(stan::math::exp(multiply(Z, psi)))));
            }
            current_statement_begin__ = 49;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 50;
                stan::model::assign(phi, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((1 - get_base1(theta, i, "theta", 1)) / get_base1(theta, i, "theta", 1)), 
                            "assigning variable phi");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 25;
            check_greater_or_equal(function__, "mu", mu, 0);
            check_less_or_equal(function__, "mu", mu, 1);
            current_statement_begin__ = 26;
            check_greater_or_equal(function__, "theta", theta, 0);
            check_less_or_equal(function__, "theta", theta, 1);
            current_statement_begin__ = 27;
            check_greater_or_equal(function__, "phi", phi, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t mu_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t theta_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                    vars__.push_back(theta(j_1__));
                }
                size_t phi_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                    vars__.push_back(phi(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 78;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 79;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 80;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((((((((stan::math::lgamma((get_base1(n, i, "n", 1) + 1)) - stan::math::lgamma((get_base1(y, i, "y", 1) + 1))) - stan::math::lgamma(((get_base1(n, i, "n", 1) - get_base1(y, i, "y", 1)) + 1))) + stan::math::lgamma(get_base1(phi, i, "phi", 1))) - stan::math::lgamma((get_base1(phi, i, "phi", 1) * get_base1(mu, i, "mu", 1)))) - stan::math::lgamma((get_base1(phi, i, "phi", 1) * (1 - get_base1(mu, i, "mu", 1))))) + stan::math::lgamma(((get_base1(phi, i, "phi", 1) * get_base1(mu, i, "mu", 1)) + get_base1(y, i, "y", 1)))) + stan::math::lgamma((((get_base1(phi, i, "phi", 1) * (1 - get_base1(mu, i, "mu", 1))) + get_base1(n, i, "n", 1)) - get_base1(y, i, "y", 1)))) - stan::math::lgamma((get_base1(phi, i, "phi", 1) + get_base1(n, i, "n", 1)))), 
                            "assigning variable log_lik");
            }
            // validate, write generated quantities
            current_statement_begin__ = 78;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_BetaBin_theta";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t psi_j_1_max__ = H;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t mu_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t phi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_BetaBin_theta_namespace::model_BetaBin_theta stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
