#' Forest Many-Objective Robust Decision Making (FoRDM)
#'
#' @description
#' This package provides a toolkit for supporting robust forest management under deep uncertainty.
#' It provides a forestry-focused application of Many-Objective Robust Decision Making (MORDM) to forest simulation outputs,
#' enabling users to evaluate robustness using regret- and satisficing-based measures. FoRDM identifies robust solutions,
#' generates Pareto fronts, and offers interactive 2D, 3D, and parallel-coordinate visualizations.
#'
#' @details
#' Main features:
#' \itemize{
#'   \item Create FoRDM input tables from forest simulation outputs.
#'   \item Calculate robustness measures based on Regret and Satisficing approaches.
#'   \item Visualize results using 2D, 3D, or parallel-coordinate plots.
#'   \item Explore trade-offs between robustness and performance.
#' }
#'
#' @docType package
#' @name FoRDM
#' @encoding UTF-8
#' @author Marc Djahangard \email{marc.djahangard@ife.uni-freiburg.de} (author, maintainer)
#' @author Rasoul Yousefpour (author)
#'
#' @seealso browseVignettes(package = "FoRDM")
"_PACKAGE"