% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{boot_cs}
\alias{boot_cs}
\title{Cross-sectional Joint Bootstrap}
\usage{
boot_cs(fit, boot_size, h, seed = NULL)
}
\arguments{
\item{fit}{A list of \mjseqn{n} base forecast models. It is important to note that the models
must have the \code{simulate()} function available and implemented as with
the package \pkg{forecast}, with the following mandatory parameters:
\emph{object}, \emph{innov}, \emph{future}, and \emph{nsim}.}

\item{boot_size}{The number of bootstrap replicates.}

\item{h}{Block size of the bootstrap, which is typically equivalent to the forecast horizon.}

\item{seed}{An integer seed.}
}
\value{
A list with two elements: the seed used to sample the errors and a 3-d array
(\mjseqn{boot\_size\times n \times h})
}
\description{
Joint block bootstrap for generating probabilistic base forecasts that take into account
the correlation between different time series (Panagiotelis et al. 2023).
}
\references{
Panagiotelis, A., Gamakumara, P., Athanasopoulos, G. & Hyndman, R. J. (2023),
Probabilistic forecast reconciliation: Properties, evaluation and score optimisation,
\emph{European Journal of Operational Research} 306(2), 693–706.
}
\seealso{
Other bootstrap: 
\code{\link{boot_ct}()},
\code{\link{boot_te}()}
}
\concept{bootstrap}
