% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconcile.fossils.taxonomy.R
\name{reconcile.fossils.taxonomy}
\alias{reconcile.fossils.taxonomy}
\title{Reconcile existing fossil and taxonomy objects}
\usage{
reconcile.fossils.taxonomy(fossils, taxonomy)
}
\arguments{
\item{fossils}{Fossils object.}

\item{taxonomy}{Taxonomy object.}
}
\value{
An object of class fossils.
}
\description{
This function uses edge identifiers (\code{edge}) and fossil sampling times (\code{hmin}) to reassign fossil species identifiers (\code{sp, origin}) using an existing taxonomy object.
It can only be used if exact fossil sampling times are known (i.e. \code{hmin = hmax}), otherwise edges containing multiple species may be indistinguishable.
}
\examples{
# simulate tree
t = ape::rtree(6)

# simulate fossils using the tree
rate = 2
f = sim.fossils.poisson(rate, tree = t)
plot(f, t)

# simulate fossils using taxonomy
s = sim.taxonomy(t, 0.5, 1, 0.5)
f = reconcile.fossils.taxonomy(f, s)
plot(f, t)

}
