% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.taxonomy.R
\name{sim.taxonomy}
\alias{sim.taxonomy}
\title{Simulate taxonomy}
\usage{
sim.taxonomy(tree, beta = 0, lambda.a = 0, kappa = 0,
  root.edge = TRUE)
}
\arguments{
\item{tree}{Phylo object.}

\item{beta}{Probability of bifurcating speciation. Default = 0.}

\item{lambda.a}{Rate of anagenetic speciation. Default = 0.}

\item{kappa}{Probability that speciation event is cryptic. Default = 0.}

\item{root.edge}{If TRUE include root edge. Default = TRUE.}
}
\value{
An object of class taxonomy.
}
\description{
Simulate a taxonomy object relating species identity to a phylo object under a mixed model of speciation.
Anagenetic and cryptic species can also be added later using the \code{sim.anagenetic.species} and \code{sim.cryptic.species} functions.
}
\examples{
t = ape::rtree(10)
sim.taxonomy(t, 0.5, 0.1, 0.5)

}
\seealso{
\code{\link{taxonomy}}
}
