% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-getFuzzyScale.R
\docType{methods}
\name{getFuzzyScale}
\alias{getFuzzyScale}
\alias{getFuzzyScale,character-method}
\title{Function to create Fuzzy Scale}
\usage{
getFuzzyScale(type)

\S4method{getFuzzyScale}{character}(type)
}
\arguments{
\item{type}{An object of class \code{character}. Two values are possible \code{"full"} and
\code{"basic"}.}
}
\value{
A \code{matrix} representing the fuzzy scale.
}
\description{
This methods creates fuzzy scale that are used while fuzzifying Piecewise comparison matrix.

Full scale is:
\tabular{ccc}{
1/2 \tab 1 \tab 2 \cr
1 \tab 2 \tab 3 \cr
2 \tab 3 \tab 4 \cr
3 \tab 4 \tab 5 \cr
4 \tab 5 \tab 6 \cr
5 \tab 6 \tab 7 \cr
6 \tab 7 \tab 8 \cr
7 \tab 8 \tab 9 \cr
8 \tab 9 \tab 9
}

Basic scale is:
\tabular{ccc}{
1/3 \tab 1 \tab 3 \cr
1 \tab 3 \tab 5 \cr
3 \tab 5 \tab 7 \cr
5 \tab 7 \tab 9 \cr
7 \tab 9 \tab 9
}
}

