% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_order.R
\name{fs_order}
\alias{fs_order}
\title{Fuzzy monetary poverty estimation (Step 1)}
\usage{
fs_order(data, vec_order)
}
\arguments{
\item{data}{a data-set of n columns with the considered items}

\item{vec_order}{a vector of length n with TRUE or FALSE. True if the order of the variable is to be inverted, False otherwise}
}
\value{
A data.frame with the same item of data  with inverted order for those with vec_order==TRUE
}
\description{
Detects and inverts deprivation items for FS
}
\examples{

#Create data
 
data=data.frame("X"=rep(c(1,2,3,4),20), "Y"=rep(c(7,8,9,1),20))

#Crete vec_order

vec_order=c(TRUE,FALSE)

fs_order(data=data, vec_order)

}
\references{
Betti, G., Gagliardi, F., Lemmi, A., & Verma, V. (2015). Comparative measures of multidimensional deprivation in the European Union. Empirical Economics, 49(3), 1071-1100.

Betti, G., Gagliardi, F., & Verma, V. (2018). Simplified Jackknife variance estimates for fuzzy measures of multidimensional poverty. International Statistical Review, 86(1), 68-86.
}
