% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateFuzzyNumber.R
\name{SimulateFuzzyNumber}
\alias{SimulateFuzzyNumber}
\title{Simulate random fuzzy number.}
\usage{
SimulateFuzzyNumber(
  originalRandomDist,
  parametersOriginalRD,
  increasesCoreRandomDist,
  parametersCoreIncreasesRD,
  supportLeftRandomDist,
  parametersSupportLeftRD,
  supportRightRandomDist,
  parametersSupportRightRD,
  knotNumbers = 0,
  type = "trapezoidal"
)
}
\arguments{
\item{originalRandomDist}{Name of the random generator used to create the "true origin" of fuzzy number (as
defined in the \code{stats} package).}

\item{parametersOriginalRD}{List of parameters required by the random generator used
to create the "true origin" of a fuzzy number.}

\item{increasesCoreRandomDist}{Name of the random generator used to create the increases of the core of fuzzy
number (as defined in the \code{stats} package).}

\item{parametersCoreIncreasesRD}{List of parameters required by the random generator used
to create the increases of the core of trapezoidal number.}

\item{supportLeftRandomDist}{Name of the random generator used to create the increase of the left support of fuzzy
number (as defined in the \code{stats} package).}

\item{parametersSupportLeftRD}{List of parameters required by the random generator used
to create the increase of the left support of fuzzy  number.}

\item{supportRightRandomDist}{Name of the random generator used to create the increase of the right support of fuzzy
number (as defined in the \code{stats} package).}

\item{parametersSupportRightRD}{List of parameters required by the random generator used
to create the increase of the right support of trapezoidal number.}

\item{knotNumbers}{Number of the knots necessary to generate the output fuzzy number.}

\item{type}{Type of the generated fuzzy number ("triangular", "trapezoidal", or "PLFN").}
}
\value{
The output is given as a list of two values:
\code{original} with "true origin" of the simulated fuzzy number generated
 from the random distribution \code{originalRandomDist},
and \code{value} -- the simulated triangular, trapezoidal, or PLFN fuzzy number as in the \code{FuzzyNumbers} package.
}
\description{
`SimulateFuzzyNumber` generates a single fuzzy number using the
various random distributions based on the functions from the \code{stats} package.
}
\details{
The procedure randomly generates a fuzzy number (a triangular, trapezoidal, or PLFN one) with the
original, increases of its core, and increases of its support given by some random distributions.
The names of the respective functions of these probability distributions should be in the form
 required by the \code{stats} package.
For triangular fuzzy number, \code{increasesRandomDist} is not used.
For both triangular and trapezoidal fuzzy numbers, \code{knotNumbers} is not used.


The "true origin" of the fuzzy number is independently drawn from the random distribution using
\code{originalRandomDist} function from the \code{stats} package with the list of parameters defined by
\code{parametersOriginalRD}.
The same applies to the increases of the core (the function \code{increasesCoreRandomDist} with the parameters
\code{parametersCoreIncreasesRD} is then used), the left increase of the support (the function \code{supportLeftRandomDist}
 with the parameters \code{parametersSupportLeftRD}, respectively), and the right increase of the support
 (the function \code{supportRightRandomDist}
 with the parameters \code{parametersSupportRightRD}, respectively).
}
\examples{

# seed PRNG

set.seed(1234)

# generate triangular fuzzy number (the normal distribution for the "true origin",
# and two different uniform distribution for the increases of the support)

SimulateFuzzyNumber(originalRandomDist="rnorm",parametersOriginalRD=list(mean=0,sd=1),
supportLeftRandomDist="runif",parametersSupportLeftRD=list(min=0,max=0.6),
supportRightRandomDist="runif", parametersSupportRightRD=list(min=0,max=0.6),
type="triangular")

# generate trapezoidal fuzzy number (the normal distribution for the "true origin",
# the exponential distribution for the increases of the core,
# and two different uniform distribution for the increases of the support)

SimulateFuzzyNumber(originalRandomDist="rnorm",parametersOriginalRD=list(mean=0,sd=1),
increasesCoreRandomDist="rexp", parametersCoreIncreasesRD=list(rate=2),
supportLeftRandomDist="runif",parametersSupportLeftRD=list(min=0,max=0.6),
supportRightRandomDist="runif", parametersSupportRightRD=list(min=0,max=0.6),
type="trapezoidal")

# generate PLFN fuzzy number with two knots

SimulateFuzzyNumber(originalRandomDist="rnorm",parametersOriginalRD=list(mean=0,sd=1),
increasesCoreRandomDist="rexp", parametersCoreIncreasesRD=list(rate=2),
supportLeftRandomDist="runif",parametersSupportLeftRD=list(min=0,max=0.6),
supportRightRandomDist="runif", parametersSupportRightRD=list(min=0,max=0.6),
knotNumbers = 2,
type="PLFN")


}
\references{
Ban, A.I., Coroianu, L., Grzegorzewski, P. (2015)
Fuzzy Numbers: Approximations, Ranking and Applications.
Institute of Computer Sciences, Polish Academy of Sciences


Grzegorzewski, P., Romaniuk, M. (2022)
Bootstrap methods for fuzzy data.
Uncertainty and Imprecision in Decision Making and Decision Support: New Advances, Challenges, and Perspectives, pp. 28-47
Springer

Gagolewski, M., Caha, J. (2021) FuzzyNumbers Package: Tools to deal with fuzzy numbers in R.
R package version 0.4-7, https://cran.r-project.org/web/packages=FuzzyNumbers
}
\seealso{
\code{\link{SimulateSample}} for generation of the whole random fuzzy sample
}
