% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmncv.R
\name{plot.ggmncv}
\alias{plot.ggmncv}
\title{Plot \code{ggmncv} Objects}
\usage{
\method{plot}{ggmncv}(x, size = 1, color = "black", ...)
}
\arguments{
\item{x}{An object of class \code{ggmncv}}

\item{size}{Numeric. The size of the points (defaults to 1).}

\item{color}{Character string. The color of the points (defaults to \code{black})}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot} object
}
\description{
Plot variable inclusion 'probabilities'
}
\examples{

# data
Y <- GGMncv::ptsd[,1:10]

# correlations
S <- cor(Y, method = "spearman")

# fit model
fit <- GGMncv(x = S, n = nrow(Y),
              penalty = "atan",
              vip = TRUE,
              vip_iter = 50)

# plot
plot(fit, size = 4)

}
