% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_graph.R
\name{plot.graph}
\alias{plot.graph}
\title{Network Plot for \code{select} Objects}
\usage{
\method{plot}{graph}(
  x,
  layout = "circle",
  neg_col = "#D55E00",
  pos_col = "#009E73",
  edge_magnify = 1,
  node_size = 10,
  palette = 2,
  node_names = NULL,
  node_groups = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{graph} obtained from \code{\link[GGMncv]{get_graph}}.}

\item{layout}{Character string. Which graph layout (defaults is \code{circle}) ?
See \link[sna]{gplot.layout}.}

\item{neg_col}{Character string. Color for the positive edges
(defaults to a colorblind friendly red).}

\item{pos_col}{Character string.  Color for the negative edges
(defaults to a colorblind friendly green).}

\item{edge_magnify}{Numeric. A value that is multiplied by the edge weights. This increases (> 1) or
decreases (< 1) the line widths (defaults to 1).}

\item{node_size}{Numeric. The size of the nodes (defaults to \code{10}).}

\item{palette}{A character string sepcifying the palette for the \code{groups}.
(default is \code{Set3}). See \href{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/}{palette options here}.}

\item{node_names}{Character string. Names for nodes of length \emph{p}.}

\item{node_groups}{A character string of length \emph{p} (the number of nodes in the model).
This indicates groups of nodes that should be the same color
(e.g., "clusters" or "communities").}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{ggplot}
}
\description{
Visualize the conditional dependence structure.
}
\examples{
\donttest{

Y <- na.omit(bfi[,1:25])

fit <- ggmncv(cor(Y), n = nrow(Y),
              progress = FALSE)

plot(get_graph(fit))

}
}
