% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{aggregate_cov}
\alias{aggregate_cov}
\title{Aggregate covariates}
\usage{
aggregate_cov(
  data = NULL,
  var = NULL,
  time = NULL,
  area = NULL,
  aggregate_space = NULL,
  aggregate_time = NULL,
  aggregate_space_fun = "mean",
  aggregate_time_fun = "mean"
)
}
\arguments{
\item{data}{Data frame containing equally spaced
(daily, weekly, monthly) incident cases for one or multiple areas.}

\item{var}{Name of the variable that identifies the covariate.}

\item{time}{Name of the variable that identifies the temporal dimension.
The values must be in date format ("yyyy-mm-dd")
representing the date of observation for daily data, the first day of the
week for weekly, or the first day of the month for monthly observations.}

\item{area}{Name of variable that identifies the different locations
(i.e., areal units) for which a time series is available.}

\item{aggregate_space}{Name of variable used to define spatial aggregation groups.}

\item{aggregate_time}{Temporal scale used to perform
temporal aggregation. Options are: "week" (ISO 8601), "month", "year".}

\item{aggregate_space_fun}{Character indicating the function to be used
in the aggregation over space, default is "mean".}

\item{aggregate_time_fun}{Character indicating the function to be used
in the aggregation over time, default is "mean".}
}
\value{
A data frame with the aggregated covariate.
}
\description{
Aggregates a data frame containing a covariate of interest in
space and/or time.
}
