% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_processor.R
\name{fit_model_and_process}
\alias{fit_model_and_process}
\title{Fit the cosinor GLMM model using the output from
\code{update_formula_and_data()} and a new formula}
\usage{
fit_model_and_process(obj, formula, ...)
}
\arguments{
\item{obj}{Output from \code{update_formula_and_data()}.}

\item{formula}{A (optionally) new formula to use when fitting the cosinor
model (maybe with random effects) or other covariates found in the data.}

\item{...}{Optional additional arguments passed to \code{glmmTMB::glmmTMB()}.}
}
\value{
Returns a fitted cosinor model as a \code{cglmm} object.
}
\description{
Fit the cosinor GLMM model using the output from
\code{update_formula_and_data()} and a new formula
}
\examples{
# Use vitamind data but add a "patient" identifier used as a random effect
vitamind2 <- vitamind
vitamind2$patient <- sample(
  LETTERS[1:5],
  size = nrow(vitamind2), replace = TRUE
)

# Use update_formula_and_data() to perform wrangling steps of cglmm()
# without yet fitting the model
data_and_formula <- update_formula_and_data(
  data = vitamind2,
  formula = vit_d ~ X + amp_acro(time,
    group = "X",
    period = 12
  )
)

# print formula from above
data_and_formula$newformula

# fit model while adding random effect to cosinor model formula.
mod <- fit_model_and_process(
  obj = data_and_formula,
  formula = update.formula(
    data_and_formula$newformula, . ~ . + (1 | patient)
  )
)

mod
mod$fit # printing the `glmmTMB` model within shows Std.Dev. of random effect
}
