% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rtheta}
\alias{rtheta}
\title{Get random parameters for the Gaussian mixture (copula) model}
\usage{
rtheta(m = 3, d = 2)
}
\arguments{
\item{m}{The number of components in the mixture.}

\item{d}{The dimension of the mixture distribution.}
}
\value{
A named list of parameters with the 4 elements:
  \item{\code{m}}{An integer giving the number of components in the mixture.
    Default is 3.}
  \item{\code{d}}{An integer giving the dimension of the mixture
    distribution. Default is 2.}
  \item{\code{pie}}{A numeric vector of length \code{m} of mixture
    proportions between 0 and 1 which sums to one.}
  \item{\code{mu}}{A list of length \code{m} of numeric vectors of length
    \code{d} for each component.}
  \item{\code{sigma}}{A list of length \code{m} of variance-covariance
     matrices (of size \code{d} times \code{d}) for each component.}
}
\description{
The function generates a random set parameters for the Gaussian mixture
model (GMM) and Gaussian mixture copula model (GMCM).
}
\note{
The function \code{\link{is.theta}} checks whether or not \code{theta}
  is in the correct format.
}
\examples{
rtheta()
rtheta(d = 5, m = 2)

test <- rtheta()
is.theta(test)
}
\author{
Anders Ellern Bilgrau (abilgrau@math.aau.dk)
}
\seealso{
\code{\link{is.theta}}
}

