% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{user}
\alias{user}
\title{User model}
\usage{
user(RESOURCES = NULL, AGENTS = NULL, LAND = NULL, PARAS = NULL,
  COST = NULL, ACTION = NULL, INTERACT = NULL, inter_tabl = NULL,
  model = "IBM")
}
\arguments{
\item{RESOURCES}{The resources array produced by the resource function within GMSE}

\item{AGENTS}{The array of agents produced in the main gmse() function}

\item{LAND}{The landscape array on which interactions between resources and agents occur}

\item{PARAS}{The vector of parameters that hold global and dynamic parameter values used by GMSE}

\item{COST}{A three dimensional array of cost values for agent (manager and stakeholder) actions}

\item{ACTION}{ACTION A three dimensional array of agent (manager and stakeholder) actions}

\item{INTERACT}{An interaction (Jacobian) matrix of resources & landscape layer effects}

\item{inter_tabl}{Interaction table indexing types with the INTERACT matrix}

\item{model}{The type of model being applied (Currently only individual-based
-- i.e., 'agent-based' -- models are allowed)}
}
\value{
The user function outputs an R list that includes five separate arrays, including (1) an new RESOURCES array, (2) a new AGENTS array, (3) a new LAND array, (4) a new ACTIONS array, and a new (5) COST array, each of which might be affected by the user function. The new arrays can then be read back into the broader GMSE function, thereby affecting the input into the resource, observation, and management models.
}
\description{
A model of user decisions for a single time step. These decisions result in stakeholder actions that can potentially affect resources and the landscape in a GMSE simulation.
}
\examples{
\dontrun{
USERS <- user(RESOURCES = RESOURCES, AGENTS = AGENTS, LAND = LANDSCAPE_r,
PARAS = paras, COST = COST, ACTION = ACTION, INTERACT = Jacobian, 
inter_tabl = interaction_tabl, model = "IBM");
}
}
