% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alex.waterfall.plot.R
\name{alex.waterfall.plot}
\alias{alex.waterfall.plot}
\title{Prepare Waterfall Plot of Lesion and Expression Data}
\usage{
alex.waterfall.plot(waterfall.prep, lsn.data, lsn.clrs = NULL, delta = 0.5)
}
\arguments{
\item{waterfall.prep}{Output of the alex.waterfall.prep function. It's a list of three data tables that include "gene.lsn.exp" that has patient ID, lesion type that affect this gene if any and expression level of the selected gene, "lsns" which is a data table with all lesions affecting the gene of interest in a GRIN compatible format and "stats" which is one row with the Kruskal-Wallis test result (output of the KW.hit.express function).}

\item{lsn.data}{Lesion data in a GRIN compatible format.}

\item{lsn.clrs}{Assigned colors per lesion types. If not specified, colors will be automatically assigned using default.grin.colors function.}

\item{delta}{Spacing argument for the waterfall plot.}
}
\value{
Function return a waterfall plot for expression data by lesion groups of a selected gene.
}
\description{
Function return a waterfall plot for expression data by lesion groups of a selected gene.
}
\details{
Function return a waterfall plot for expression data by lesion groups of a selected gene. This plot offers a side by side graphical representation of lesion and expression data for each patient where lesion groups are ordered alphabetically. For each lesion category, expression data is ordered from the lowest to the highest with patient with the median expression of the gene in the middle of the panel.
}
\examples{
data(expr.data)
data(lesion.data)
data(hg19.gene.annotation)

# prepare expression, lesion data and return the set of genes with both types of data available
# ordered by gene IDs in rows and patient IDs in columns:
alex.data=alex.prep.lsn.expr(expr.data, lesion.data,
                             hg19.gene.annotation, min.expr=1, min.pts.lsn=5)

# run KW test for association between lesion groups and expression level of the same gene:
alex.kw.results=KW.hit.express(alex.data, hg19.gene.annotation, min.grp.size=5)

# To prepare lesion and expression data for a waterfall plot (WT1 gene):
WT1.waterfall.prep=alex.waterfall.prep(alex.data, alex.kw.results, "WT1", lesion.data)

# waterfall plot of WT1 gene:
WT1.waterfall.plot=alex.waterfall.plot(WT1.waterfall.prep, lesion.data)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=alex.prep.lsn.expr]{alex.prep.lsn.expr()}}, \code{\link[=KW.hit.express]{KW.hit.express()}}, \code{\link[=alex.waterfall.prep]{alex.waterfall.prep()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
