% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.hits.R
\name{count.hits}
\alias{count.hits}
\title{Count Gene Lesion Hits}
\usage{
count.hits(ov.data)
}
\arguments{
\item{ov.data}{a list of six data.frames that represent the output results of the find.gene.lsn.overlaps function.}
}
\value{
A list with the following components:
\item{lsn.data}{Input lesion data}
\item{lsn.index}{data.frame that shows the overlapped gene-lesion data rows taht belong to each lesion in the gene.lsn.data table.}
\item{gene.data}{Input gene annotation data}
\item{gene.index}{data.frame with overlapped gene-lesion data rows that belong to each chromosome in the gene.lsn.data table.}
\item{nhit.mtx}{A data.frame with number of hits in each gene by lesion type (number of columns will be equal to the number of lesion types in the lsn.type column).}
\item{nsubj.mtx}{A data.frame with number of affected subjects by lesion type in each annotated gene.}
\item{gene.lsn.data}{Each row represent a gene overlapped by a certain lesion. Column "gene" shows the overlapped gene and "ID" column has the patient ID.}
\item{glp.data}{data.frame ordered by gene and lesions start position. Gene start position is coded as 1 in the cty column and gene end position is coded as 4. Lesion start position is coded as 2 in the cty column and lesion end position is coded as 3.}
}
\description{
The function computes the number of hits affecting each gene by lesion category. It also compute the number of subjects with a hit in each annotated gene by lesion category as well.
}
\details{
The function use the output of the find.gene.lsn.overlaps function and return the number of unique subjects affected by each lesion category in the provided list of annotated genes and regulatory features (nsubj stats). It also count the number of hits affecting each loci per lesion category (nhits stats). For example, if NOTCH1 gene was found affected by three different mutations in the same subject, this patient will be considered as one subject in the nsubj stats but in the nhits stats for this event will be counted as 3 mutations that affect NOTCH1 gene.
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)

# prepare gene and lesion data for later computations:
prep.gene.lsn=prep.gene.lsn.data(lesion.data,
                                 hg19.gene.annotation)

# determine lesions that overlap each gene (locus):
gene.lsn.overlap=find.gene.lsn.overlaps(prep.gene.lsn)

# count number of subjects affected by different types of lesions and number of hits that affect
# each locus:
count.nsubj.nhits=count.hits(gene.lsn.overlap)
}
\references{
Pounds, Stan, et al. (2013) A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=prep.gene.lsn.data]{prep.gene.lsn.data()}}, \code{\link[=find.gene.lsn.overlaps]{find.gene.lsn.overlaps()}}
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
