###########################################################
## Compute GSE
###########################################################
.GSE.Rcpp <- function(x, mu0, S0, tol, maxiter, tol.scale, miter.scale, 
	miss.group.unique, miss.group.counts, tuning.const.group, print.step, bdp){

	res <- tryCatch( .Call("GSE", x, nrow(x), ncol(x), mu0, S0, 
		tol, maxiter, tol.scale, miter.scale, miss.group.unique, miss.group.counts, 
		tuning.const.group, print.step, bdp),
		"std::range_error" = function(e){
		conditionMessage( e ) } )
	## Main error messages
	if( res$error_code == 1 ) warning("Generalized S-scale is non-positive.")
	else if( res$error_code == 2 ) warning("Estimated covariance matrix is not positive definite.")

	## Reached max number of iteration messages
	#if( res$iter <= maxiter & print.step == 1) cat(paste("Reached convergence in", res$iter, "iterations.\n") )
	if(res$iter > maxiter) warning("Reached maximum number of iteration. No convergence is achieved.")
	
	res
}
###########################################################



#############################################################
## Tuning constant of rho for a given p 
#############################################################
.rho.tune <- function(u, bdp){

uu <- switch(as.character(bdp),
"0.5"=c(
2.3952,7.0799,11.9224,16.7818,21.6413,
26.4987,31.354,36.2077,41.0602,45.9118,
50.7626,55.613,60.4629,65.3124,70.1617,
75.0107,79.8595,84.7082,89.5568,94.4052,
99.2535,104.1017,108.9499,113.798,118.646,
123.494,128.3419,133.1898,138.0376,142.8854,
147.7332,152.581,157.4287,162.2764,167.1241,
171.9717,176.8194,181.667,186.5146,191.3622,
196.2098,201.0574,205.9049,210.7525,215.6,
220.4476,225.2951,230.1426,234.9901,239.8376,
244.6851,249.5326,254.38,259.2275,264.075,
268.9224,273.7699,278.6174,283.4648,288.3122,
293.1597,298.0071,302.8546,307.702,312.5494,
317.3968,322.2443,327.0917,331.9391,336.7865,
341.6339,346.4813,351.3287,356.1761,361.0235,
365.8709,370.7183,375.5657,380.4131,385.2605,
390.1079,394.9553,399.8027,404.65,409.4974,
414.3448,419.1922,424.0396,428.8869,433.7343,
438.5817,443.4291,448.2764,453.1238,457.9712,
462.8185,467.6659,472.5133,477.3606,482.208,
487.0554,491.9027,496.7501,501.5975,506.4448,
511.2922,516.1396,520.9869,525.8343,530.6816,
535.529,540.3763,545.2237,550.0711,554.9184,
559.7658,564.6131,569.4605,574.3078,579.1552,
584.0025,588.8499,593.6972,598.5446,603.3919,
608.2393,613.0866,617.934,622.7813,627.6287,
632.476,637.3234,642.1707,647.0181,651.8654,
656.7128,661.5601,666.4075,671.2548,676.1021,
680.9495,685.7968,690.6442,695.4915,700.3389,
705.1862,710.0335,714.8809,719.7282,724.5756,
729.4229,734.2703,739.1176,743.9649,748.8123,
753.6596,758.507,763.3543,768.2016,773.049,
777.8963,782.7436,787.591,792.4383,797.2857,
802.133,806.9803,811.8277,816.675,821.5224,
826.3697,831.217,836.0644,840.9117,845.759,
850.6064,855.4537,860.301,865.1484,869.9957,
874.8431,879.6904,884.5377,889.3851,894.2324,
899.0797,903.9271,908.7744,913.6217,918.4691,
923.3164,928.1637,933.0111,937.8584,942.7057,
947.5531,952.4004,957.2477,962.0951,966.9424
),
"0.25"=c(
c(8.624,19.61,30.559,41.511,52.445,
63.401,74.332,85.272,96.213,107.136,
118.084,129.039,139.957,150.9,161.834,
172.775,183.692,194.632,205.571,216.493,
227.455,238.396,249.354,260.292,271.184, 
282.153,293.055,304.031,314.936,325.866, 
336.844,347.766,358.693,369.603,380.574,
391.516,402.462,413.379,424.268,435.192,
446.215,457.106,468.07,478.965,489.929,
500.875,511.788,522.707,533.646,544.584,
555.539,566.426,577.458,588.343,599.27,
610.239,621.16,632.091,643.067,653.969,
664.912,675.839,686.756,697.659,708.616,
719.546,730.521,741.468,752.426,763.313,
774.283,785.24,796.133,807.054,818.016,
828.959,839.917,850.829,861.764,872.667,
883.631,894.535,905.544,916.458,927.326,
938.278,949.254,960.221,971.114,982.047,
992.998,1003.89,1014.867,1025.789,1036.791,
1047.677,1058.61,1069.499,1080.444,1091.417,
1102.336,1113.218,1124.256,1135.178,1146.106,
1157.056,1167.943,1178.921,1189.83,1200.762,
1211.733,1222.665,1233.558,1244.491,1255.451,
1266.384,1277.319,1288.263,1299.157,1310.139,
1321.039,1332,1343.022,1353.93,1364.757,
1375.743,1386.684,1397.628,1408.616,1419.467,
1430.441,1441.378,1452.291,1463.259,1474.233,
1485.153,1496.065,1506.967,1517.905,1528.965,
1539.833,1550.744,1561.72,1572.596,1583.543,
1594.45,1605.411,1616.316,1627.287,1638.238,
1649.162,1660.088,1671.019,1681.936,1692.88,
1703.779,1714.736,1725.697,1736.724,1747.578,
1758.495,1769.429,1780.351,1791.351,1802.312,
1813.187,1824.081,1835.11,1845.995,1856.924,
1867.911,1878.778,1889.778,1900.634,1911.663,
1922.634,1933.474,1944.428,1955.369,1966.321,
1977.314,1988.165,1999.168,2010.022,2020.974,
2031.924,2042.829,2053.789,2064.747,2075.748,
2086.595,2097.518,2108.511,2119.422,2130.409,
2141.242,2152.218,2163.195,2174.081,2185.025)
))

tt <- uu[u]
tt
}



