% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlite_db_check.R
\name{sqlite.db.check}
\alias{sqlite.db.check}
\title{Check the data in the reference database}
\usage{
sqlite.db.check(inspector)
}
\arguments{
\item{inspector}{An instance of \linkS4class{Inspector} class. Check \code{\link{setup.inspector}} for more details.}
}
\value{
This function returns a data table including the summary of the specified database. This is necessary to check the consistency and validity of an unknown or new database file.
}
\description{
This function displays the summary of the database, including how many tables are in the database file, number of data rows for each data table and the first row of each table.
}
\details{
This function only checks databases in sqlite format.
}
\note{
First column include the names of the tables in database

Second column is the number of rows in each table

Next columns are the first row of each table
}
\examples{
config.file <- get.config(tempdir())
inspector <- setup.inspector(config.file , validate = FALSE)
# use sample database embedded in the package
inspector@supplementaryFiles$allele_ref_std <- system.file("extdata",
                                                            "sample_db.sqlite",
                                                             package = "GWASinspector")
sqlite.db.check(inspector)

}
