% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiled_code_gamabiomd.R
\name{get_sequence_information}
\alias{get_sequence_information}
\title{Retrieves sequence information for a given list of accessions.}
\usage{
get_sequence_information(accession, remove_dot_1 = FALSE)
}
\arguments{
\item{accession}{accession number.}

\item{remove_dot_1}{Logical. If TRUE, removes '.1' from accession numbers.}
}
\value{
A data frame containing sequence information for the given accessions.
}
\description{
Retrieves sequence information for a given list of accessions.
}
\examples{
\donttest{
accession_ranges <- list(
  SRU1 = "AJ240966 to AJ240970",
  STU2 = "AB015240 to AB015245",
  WPU13 = "L11934 to L11939",
  INU20 = c("AF277467 to AF277470", "AF333080 to AF333085")
)

# Use the function to expand accession ranges
sam_acc <- expand_accession_ranges(accession_ranges)
print(sam_acc)

# 2 get_sequence_information
accessions_to_query <- sam_acc$accession
seq_info <- get_sequence_information(accessions_to_query, remove_dot_1 = TRUE)
print(seq_info)
}
}
