% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTest.R
\name{ParamTest}
\alias{ParamTest}
\title{Input Parameter Test}
\usage{
ParamTest(Occurrence_data, Raster)
}
\arguments{
\item{Occurrence_data}{A data frame object with the species name,
geographical coordinates, and type of records (G or H) for a given species}

\item{Raster}{A raster object representing the species distribution model}
}
\value{
A list with two binary values
}
\description{
Preforms a series of test to validation that input occurrence
  data and SDM meet require parameters
}
\examples{
##Obtaining occurrences from example
data(CucurbitaData)
##Obtaining Raster_list
data(CucurbitaRasters)
##Run function
test <- ParamTest(Occurrence_data = CucurbitaData[CucurbitaData$taxon == "Cucurbita Cordata",],
                  Raster = CucurbitaRasters[[1]])
}
\author{
Dan Carver
}
\keyword{internal}
