% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Singleton.R
\name{SingletonUniqueContributor}
\alias{SingletonUniqueContributor}
\title{Unique contributor singleton function}
\usage{
SingletonUniqueContributor(
  data,
  freqVar = NULL,
  nUniqueVar = NULL,
  charVar = NULL,
  removeCodes = character(0),
  integerSingleton = length(charVar) > 0,
  x,
  primary = integer(0),
  whenPrimaryMatters = warning,
  whenNoVar = TRUE,
  ...
)
}
\arguments{
\item{data}{Input data, possibly pre-aggregated within \code{GaussSuppressionFromData}}

\item{freqVar}{A single variable holding counts (input to \code{GaussSuppressionFromData})}

\item{nUniqueVar}{A single variable holding the number of unique contributors.}

\item{charVar}{Variable with contributor codes.}

\item{removeCodes}{Vector, list or data frame of codes considered non-singletons.
Single element lists and single column data frames behave just like vectors.
In other cases, \code{charVar}-names must be used.
With empty \code{charVar} a vector of row indices is assumed and conversion to integer is performed.
See examples.}

\item{integerSingleton}{Integer output when \code{TRUE}. See details.}

\item{x}{ModelMatrix generated by parent function}

\item{primary}{Vector (integer or logical) specifying primary suppressed cells.
It will be ensured that any non-suppressed inner cell is not considered a singleton.}

\item{whenPrimaryMatters}{Function to be called when \code{primary} caused non-singleton. Supply \code{NULL} to do nothing.}

\item{whenNoVar}{When \code{TRUE}, and without \code{nUniqueVar} and \code{freqVar} in input,
all cells will be marked as singletons.}

\item{...}{Unused parameters}
}
\value{
logical or integer vector
}
\description{
Function for \code{\link{GaussSuppressionFromData}}
}
\details{
This function marks input cells as singletons according to ones in
\code{data[[nUniqueVar]]}, if available, and otherwise according to \code{data[[freqVar]]}.
The output vector can be logical or integer. When, integer, singletons are given as positive values.
Their unique values represent the unique values/combinations of \code{data[[charVar]]}.
}
\examples{
S <- function(data, ...) {
  cbind(data, singleton = SingletonUniqueContributor(data, ...))
}
d2 <- SSBtoolsData("d2")
d <- d2[d2$freq < 5, ]
d$nUnique <- round((5 - d$freq)/3)
d$freq <- round(d$freq/2)
d[7:8, 2:4] <- NA
rownames(d) <- NULL

S(d, freqVar = "freq", integerSingleton = FALSE)
S(d, freqVar = "freq", nUniqueVar = "nUnique", integerSingleton = TRUE, charVar = "main_income")
S(d, nUniqueVar = "nUnique", integerSingleton = TRUE, charVar = c("main_income", "k_group"))
S(d, freqVar = "freq", nUniqueVar = "nUnique", integerSingleton = FALSE, 
  charVar = "main_income", removeCodes = "other")
S(d, nUniqueVar = "nUnique", integerSingleton = FALSE, charVar = c("main_income", "k_group"), 
  removeCodes = c("other", "400"))
S(d, nUniqueVar = "nUnique", integerSingleton = FALSE, charVar = c("main_income", "k_group"), 
  removeCodes = data.frame(anyname = c("other", "400")))
S(d, nUniqueVar = "nUnique", integerSingleton = FALSE, charVar = c("main_income", "k_group"), 
  removeCodes = list(main_income = c("other", "pensions"), k_group = "300"))
S(d, nUniqueVar = "nUnique", integerSingleton = FALSE, charVar = c("main_income", "k_group"), 
  removeCodes = data.frame(main_income = "other", k_group = "400"))
S(d, nUniqueVar = "nUnique", integerSingleton = FALSE, removeCodes = 1:5)

x <- SSBtools::ModelMatrix(d, hierarchies = list(region = "Total"))
which(colSums(x) == 1)
which(rowSums(x[, colSums(x) == 1]) > 0)
# columns 2, 3, 4, 5, 7 correspond to inner cells: rows 3, 4, 5, 6, 8 
# with 2:4 not primary rows 3:5 are forced non-singleton
S(d, freqVar = "freq", nUniqueVar = "nUnique", integerSingleton = FALSE, x = x, primary = 5:8)

}
