% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{equals}
\alias{equals}
\title{Check if two phylogenetic trees are equal}
\usage{
equals(phylotree_1, phylotree_2)
}
\arguments{
\item{phylotree_1}{A \code{Phylotree} class object.}

\item{phylotree_2}{A \code{Phylotree} class object.}
}
\value{
A boolean, \code{TRUE} if they are equal and \code{FALSE} if not.
}
\description{
Checks wether two phylogenetic trees are equivalent or not.
}
\examples{

# Load the predefined B matrices of the package
B_mats <- GeRnika::B_mats


B_real <- B_mats[[2]]$B_real
B_alg1 <- B_mats[[2]]$B_alg1


# Instantiate two \code{Phylotree} class objects on 
# the basis of the B matrices
phylotree_real <- B_to_phylotree(
                    B = B_real)
                    
phylotree_alg1 <- B_to_phylotree(
                    B = B_alg1)


equals(phylotree_real, phylotree_alg1)
}
