/*
per.c - part of David Lucy and Robert Aykroyd's CorKern package for the R
statistical language

Copyright (C) David Lucy and Robert Aykroyd see LICENCE

David Lucy: d.j.lucy@bradford.ac.uk
Robert Aykroyd: robert@amsta.leeds.ac.uk
http://www.amsta.leeds.ac.uk/~robert/


This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
Boston, MA  02111-1307  USA
*/


/*
per - outputs the value corresponding to the ith percentage point in a probability
density function

per is given a vector which represents the bins from a probability density function
a vector of values for the centre points of each bin, the number of bins, and a number
corresponding to the percentage point of the density to find.



For Linux and Solaris systems equiped with gcc
compile with (not within R): gcc -lm per.c -c

link to R by (again not from within R): R SHLIB -o libper.so per.o

invoke from R or S with:
out <- .C(
	 "per",
	 as.double(den),
	 as.integer(lenden),
	 as.double(vals),
	 as.double(point),
	 as.double(ans),
	 )

before doing so all array variables MUST be doubles from R - single integers can
be passed as int - also a dyn.load("libper.so") never goes amiss in the calling
function.


variable list and corresponding useage:


den	double *den	*(den+ctr)	vector of density scores
vals	double *vals	*(xvals + ctr)	vector of bin centres
lenden	int *lenden	*lenden		number of bins in the density estimate
point	double *point	*point		value of ith percentage point
ans	double *ans	*ans		dummy output value generated by R

temporary:

int ctr		ctr 				counter
int bin		bin				bin in which ith point is located
float *widths		*(widths + ctr)		vector of bin widths
float *densities	*(densities + ctr)	vector of density in bin
float sum	sum				tempoary sum of density
float targ	targ				tempoary target density
float lower	lower				tempoary
float ratio	ratio				tempoary



algorthm:
here we are trying to calculate the value corresponding to the ith percentage
point under the *den probability distribution. A target is calculated from the
*point variable and the sum of the distribution so we don't have to assume the
the values in *den sum to unity. Then a vector of bin widths is calculated - as
we have only the bin centres the widths are for each bin is the distance between
it's centre and the one immediately above it - this is only sort of accurate for
non uniform bin widths, but is as good as we can do without modelling the bin
widths, and leaves us not having to assume uniform bin widths.

The bin widths are then summed until the sum is larger than ith the integrated
area under the density distribution. Linear interpolation is then used to calculate
an exact value for the ith point - again not entirely accurate but is probably
better than just giving the value corresponding to the central value of the bin.
*/






per(double *den, int *lenden, double *vals, double *point, double *ans)
{

int ctr=0, bin=0;
float widths[*lenden +1], densities[*lenden +1];
float sum = 0.0, targ = 0.0, lower=0.0, ratio=0.0, low=0.0, up=0.0;



	for(ctr=0; ctr < *lenden; ctr++)
		{
		*(widths + ctr) = *(vals + ctr + 1) - *(vals + ctr); 
		}

*(widths + *lenden) = *(widths + *lenden - 1);

	for(ctr=0; ctr < *lenden; ctr++)
		{
		*(densities + ctr) = *(widths + ctr) * *(den + ctr);
		sum += *(densities + ctr);
		}


targ = *point * sum;
sum = 0.0;
ctr =0;

	do
	{
	sum += *(densities + ctr);

		if(sum > targ)
			{
			bin = ctr;
			break;
			}
	ctr++;
	
	}while(ctr < *lenden);


lower = sum - *(densities + bin);
ratio = (targ - lower)/(sum - lower);
low = *(vals + bin) - (*(widths + bin)/2);
up = *(vals + bin) + (*(widths + bin)/2);
*ans = low + ((up - low)*ratio);




return(*ans);
}
