% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertDegToKM.R
\name{convertDegToKM}
\alias{convertDegToKM}
\title{Converts a set of coordinates in degrees into a new set of coordinates in
The Universal Transverse Mercator (UTM) zone:37 coordinate system}
\usage{
convertDegToKM(loc)
}
\arguments{
\item{loc}{A two column matrix of coordinates (The first column is longitude
and the second column is latitude).}
}
\value{
A two column matrix of  coordinates in The Universal Transverse
Mercator (UTM) zone:37 (https://www.usgs.gov/faqs/what-does-term-utm-mean-
utm-better-or-more-accurate-latitudelongitude).
}
\description{
Converts a set of coordinates in degrees into a new set of coordinates in
The Universal Transverse Mercator (UTM) zone:37 coordinate system
}
\examples{
path1 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
load(path1)
locDegree <- cbind(surveyData$long, surveyData$lat)
locKM <- convertDegToKM(loc = locDegree)
head(locKM)
}
