% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resc_val.R
\name{resc.val}
\alias{resc.val}
\title{R function to rescale the values of a dataset between a minimum and a maximum set by the user}
\usage{
resc.val(x, min.v = 0, max.v = 100)
}
\arguments{
\item{x}{Vector containing the values to be rescaled.}

\item{min.v}{Minimum value of the rescaled dataset (0 by default).}

\item{max.v}{Maximum value of the rescaled dataset (100 by default).}
}
\description{
The function allows to rescale the values of a dataset between a minimum and a maximum that are
specified by the user. In doing that, it allows to preserve the shape of the distribution of the
original data.
}
\details{
The function produces two density charts representing the distribution of the original and of the
rescaled dataset. It also returns a dataframe storing the original and rescaled values.
}
\examples{
#generate a random dataset of size 30, normally distributed with mean 1000 and
#standard deviation 10
dataset <- rnorm(30, 1000,10)

#rescale the dataset to be constrained between 10 and 100
resc.val(dataset, min.v=10, max.v=100)

}
\keyword{resc.val}
