% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_visualization.R
\name{plot_topic_terms}
\alias{plot_topic_terms}
\title{Visualize top terms for each topic}
\usage{
plot_topic_terms(model_output, n = 10)
}
\arguments{
\item{model_output}{The output from model_topics function}

\item{n}{The number of top terms to visualize for each topic}
}
\value{
A ggplot object representing the bar plot of top terms for each topic.
}
\description{
This function creates a bar plot of the top terms for each topic.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Scrape reviews
reviews <- scrape_reviews(temp_file, num_reviews = 10, use_parallel = FALSE)

# Model topics
topic_results <- model_topics(reviews, num_topics = 2, num_terms = 5, english_only = TRUE)

# Visualize top terms for each topic
plot_topic_terms(topic_results, n = 5)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
