% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_spacetime_categorical_local}
\alias{matern_spacetime_categorical_local}
\alias{d_matern_spacetime_categorical_local}
\title{Space-Time Matern covariance function with local random effects for categories}
\usage{
matern_spacetime_categorical_local(covparms, locs)

d_matern_spacetime_categorical_local(covparms, locs)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, spatial range, temporal range, smoothness, category, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{d} columns.
Each row of locs gives a point in R^d.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, spatial range, temporal range, smoothness, cat variance, cat spatial range, cat temporal range, cat smoothness, nugget),
return the square matrix of
all pairwise covariances.
This is the covariance for the following model for data from cateogory k
\deqn{ Y_k(x_i,t_i) = Z_0(x_i,t_i) + Z_k(x_i,t_i) + e_i }
where Z_0 is Matern with parameters (variance,spatial range,temporal range,smoothness)
and Z_1,...,Z_K are independent Materns with parameters
(cat variance, cat spatial range, cat temporal range, cat smoothness),
and e_1, ..., e_n are independent normals with variance (variance * nugget)
}
\section{Functions}{
\itemize{
\item \code{d_matern_spacetime_categorical_local}: Derivatives of isotropic Matern covariance
}}

\section{Parameterization}{

The covariance parameter vector is (variance, range, smoothness, category, nugget)
= \eqn{(\sigma^2,\alpha_1,\alpha_2,\nu,c^2,\tau^2)}, and the covariance function is parameterized
as
\deqn{ d = ( || x - y ||^2/\alpha_1 + |s-t|^2/\alpha_2^2 )^{1/2} }
\deqn{ M(x,y) = \sigma^2 2^{1-\nu}/\Gamma(\nu) (d)^\nu K_\nu(d) }
(x,s) and (y,t) are the space-time locations of a pair of observations.
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
The category variance \eqn{c^2} is added if two observation from same category
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }.
}

