% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdanova.R
\name{hdanova}
\alias{hdanova}
\title{High-Dimensional Analysis of Variance}
\usage{
hdanova(
  formula,
  data,
  subset,
  weights,
  na.action,
  family,
  unrestricted = FALSE,
  add_error = FALSE,
  aug_error = "denominator",
  use_ED = FALSE,
  pca.in = FALSE,
  contrasts = "contr.sum",
  coding,
  equal_baseline = FALSE,
  SStype = "II",
  REML = NULL
)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictors. See Details for more information.}

\item{data}{The data set to analyse.}

\item{subset}{Expression for subsetting the data before modelling.}

\item{weights}{Optional object weights.}

\item{na.action}{How to handle NAs (no action implemented).}

\item{family}{Error distributions and link function for Generalized Linear Models.}

\item{unrestricted}{Use unrestricted ANOVA decomposition (default = FALSE).}

\item{add_error}{Add error to LS means, e.g., for APCA.}

\item{aug_error}{Augment score matrices in backprojection. Default = "denominator"
(of F test), "residual" (force error term), nueric value (alpha-value in LiMM-PCA).}

\item{use_ED}{Use "effective dimensions" for score rescaling in LiMM-PCA.}

\item{pca.in}{Compress response before ASCA (number of components).}

\item{contrasts}{Effect coding: "sum" (default = sum-coding), "weighted", "reference", "treatment".}

\item{coding}{Defunct. Use 'contrasts' instead.}

\item{equal_baseline}{Experimental: Set to \code{TRUE} to let interactions, where a main effect is missing,
e.g., a nested model, be handled with the same baseline as a cross effect model. If \code{TRUE} the corresponding
interactions will be put in quotation marks and included in the \code{model.frame}.}

\item{SStype}{Type of sum-of-squares: "I" = sequential, "II" (default) = last term, obeying marginality,
"III" = last term, not obeying marginality.}

\item{REML}{Parameter to mixlm: NULL (default) = sum-of-squares, TRUE = REML, FALSE = ML.}
}
\value{
An \code{hdanova} object containing loadings, scores, explained variances, etc. The object has
associated plotting (\code{\link{asca_plots}}) and result (\code{\link{asca_results}}) functions.
}
\description{
This function provides a high-dimensional analysis of variance (HDANOVA) method
which can be used alone or as part of a larger analysis, e.g., ASCA, APCA, LiMM-PCA, MSCA or PC-ANOVA. It
can be called directly or through the convenince functions \code{\link{asca}}, \code{\link{apca}},
\code{\link{limmpca}}, \code{\link{msca}} and \code{\link{pcanova}}.
}
\examples{
# Load candies data
data(candies)

# Basic HDANOVA model with two factors
mod <- hdanova(assessment ~ candy + assessor, data=candies)
summary(mod)

}
