% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influence_functions.R
\name{mdffits.default}
\alias{mdffits.default}
\alias{cooks.distance.mer}
\alias{cooks.distance}
\alias{cooks.distance.lmerMod}
\alias{cooks.distance.lme}
\alias{mdffits.mer}
\alias{mdffits}
\alias{mdffits.lmerMod}
\alias{mdffits.lme}
\title{Influence on fixed effects of HLMs}
\usage{
\method{mdffits}{default}(object, ...)

\method{cooks.distance}{mer}(model, level = 1, delete = NULL, ...)

\method{cooks.distance}{lmerMod}(model, level = 1, delete = NULL, include.attr = FALSE, ...)

\method{cooks.distance}{lme}(model, level = 1, delete = NULL, include.attr = FALSE, ...)

\method{mdffits}{mer}(object, level = 1, delete = NULL, ...)

\method{mdffits}{lmerMod}(object, level = 1, delete = NULL, include.attr = FALSE, ...)

\method{mdffits}{lme}(object, level = 1, delete = NULL, include.attr = FALSE, ...)
}
\arguments{
\item{object}{fitted object of class \code{mer} or \code{lmerMod}}

\item{...}{do not use}

\item{model}{fitted model of class \code{mer} or \code{lmerMod}}

\item{level}{variable used to define the group for which cases will be
deleted.  If \code{level = 1} (default), then individual cases will be deleted.}

\item{delete}{index of individual cases to be deleted. To delete specific 
observations the row number must be specified. To delete higher level
units the group ID and \code{group} parameter must be specified.
If \code{delete = NULL} then all cases are iteratively deleted.}

\item{include.attr}{logical value determining whether the difference between 
the full and deleted parameter estimates should be included. If \code{FALSE} 
(default), a numeric vector of Cook's distance or MDFFITS is returned. 
If \code{TRUE}, a tibble with the Cook's distance or MDFFITS values in the 
first column and the parameter differences in the remaining columns is returned.}
}
\value{
Both functions return a numeric vector (or single value if 
\code{delete} has been specified) as the default. If \code{include.attr = TRUE}, 
then a tibble is returned. The first column consists of the Cook's distance or
MDFFITS values, and the later columns capture the difference between the full
and deleted parameter estimates.
}
\description{
These functions calculate measures of the change in the fixed effects
estimates based on the deletion of an observation, or group of 
observations, for a hierarchical linear model fit using \code{lmer}.
}
\details{
Both Cook's distance and MDFFITS measure the change in the 
fixed effects estimates based on the deletion of a subset of observations. 
The key difference between the two diagnostics is that Cook's distance uses
the covariance matrix for the fixed effects from the original
model while MDFFITS uses the covariance matrix from the deleted 
model.
}
\note{
Because MDFFITS requires the calculation of the covariance matrix
for the fixed effects for every model, it will be slower.
}
\examples{
data(sleepstudy, package = 'lme4')
ss <- lme4::lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# Cook's distance for individual observations
ss.cd.lev1 <- cooks.distance(ss)

# Cook's distance for each Subject
ss.cd.subject <- cooks.distance(ss, level = "Subject")

\dontrun{
data(Exam, package = 'mlmRev')
fm <- lme4::lmer(normexam ~ standLRT * schavg + (standLRT | school), Exam)

# Cook's distance for individual observations
cd.lev1 <- cooks.distance(fm)

# Cook's distance for each school
cd.school <- cooks.distance(fm, level = "school")

# Cook's distance when school 1 is deleted
cd.school1 <- cooks.distance(fm, level = "school", delete = 1)

}


# MDFFITS  for individual observations
ss.m1 <- mdffits(ss)

# MDFFITS for each Subject
ss.m.subject <- mdffits(ss, level = "Subject")

\dontrun{  

# MDFFITS  for individual observations
m1 <- mdffits(fm)

# MDFFITS for each school
m.school <- mdffits(fm, level = "school")
}
}
\references{
Christensen, R., Pearson, L., & Johnson, W. (1992) 
Case-deletion diagnostics for mixed models. \emph{Technometrics}, \bold{34}, 
38--45.
  
Schabenberger, O. (2004) Mixed Model Influence Diagnostics,
in \emph{Proceedings of the Twenty-Ninth SAS Users Group International Conference},
SAS Users Group International.
}
\seealso{
\code{\link{leverage.mer}},
\code{\link{covratio.mer}}, \code{\link{covtrace.mer}}, \code{\link{rvc.mer}}
}
\author{
Adam Loy \email{loyad01@gmail.com}
}
\keyword{models}
\keyword{regression}
