% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.locs.R
\name{calc.locs}
\alias{calc.locs}
\title{Calculate Position-based Likelihood}
\usage{
calc.locs(locs, gps = NULL, iniloc, locs.grid, dateVec)
}
\arguments{
\item{locs}{is data frame from -Locations file output from DAP/Tag Portal for WC tags and 
contains GPS, Argos, and GPE locations as applicable.}

\item{gps}{is data frame from -FastGPS file output from WC Tag Portal}

\item{iniloc}{is 2 x 5 dataframe containing day, month, year, lat, lon for 
both tag and pop locations}

\item{locs.grid}{is list output from \code{setup.locs.grid}}

\item{dateVec}{is vector of dates from tag to pop-up in 1 day increments.}
}
\value{
L is an array of lon x lat likelihood surfaces (matrices) for each 
  time point (3rd dimension)
}
\description{
\code{calc.locs} calculates likelihood estimates for each day of animal tag 
data using tag-based locations.
}
\details{
GPS and Argos positions are given a "likelihood" using this function but are
currently both considered to be "known" positions without error.
}
