/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml;

import com.microstar.xml.XmlHandler;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class XmlParser {
    private static final boolean USE_CHEATS = true;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    public static final int ATTRIBUTE_UNDECLARED = 0;
    public static final int ATTRIBUTE_CDATA = 1;
    public static final int ATTRIBUTE_ID = 2;
    public static final int ATTRIBUTE_IDREF = 3;
    public static final int ATTRIBUTE_IDREFS = 4;
    public static final int ATTRIBUTE_ENTITY = 5;
    public static final int ATTRIBUTE_ENTITIES = 6;
    public static final int ATTRIBUTE_NMTOKEN = 7;
    public static final int ATTRIBUTE_NMTOKENS = 8;
    public static final int ATTRIBUTE_ENUMERATED = 9;
    public static final int ATTRIBUTE_NOTATION = 10;
    private static Hashtable attributeTypeHash = new Hashtable();
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 0;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 1;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 2;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 3;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 4;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_EXTERNAL = 2;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_BUFFER = 4;
    private static final int INPUT_READER = 5;
    private static final int LIT_CHAR_REF = 1;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_PE_REF = 4;
    private static final int LIT_NORMALIZE = 8;
    private static final int CONTEXT_NONE = 0;
    private static final int CONTEXT_DTD = 1;
    private static final int CONTEXT_ENTITYVALUE = 2;
    private static final int CONTEXT_ATTRIBUTEVALUE = 3;
    XmlHandler handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private Stack inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private int errorCount;
    private static final int READ_BUFFER_MAX = 16384;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private Hashtable elementInfo;
    private Hashtable entityInfo;
    private Hashtable notationInfo;
    private String currentElement;
    private int currentElementContent;
    private String basePublicId;
    private String baseURI;
    private int baseEncoding;
    private Reader baseReader;
    private InputStream baseInputStream;
    private char[] baseInputBuffer;
    private int baseInputBufferStart;
    private int baseInputBufferLength;
    private Stack entityStack;
    private int context;
    private Object[] symbolTable;
    private static final int SYMBOL_TABLE_LENGTH = 1087;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;

    public void setHandler(XmlHandler handler) {
        this.handler = handler;
    }

    public void parse(String systemId, String publicId, String encoding) throws Exception {
        this.doParse(systemId, publicId, null, null, encoding);
    }

    public void parse(String systemId, String publicId, InputStream stream, String encoding) throws Exception {
        this.doParse(systemId, publicId, null, stream, encoding);
    }

    public void parse(String systemId, String publicId, Reader reader) throws Exception {
        this.doParse(systemId, publicId, reader, null, null);
    }

    private synchronized void doParse(String systemId, String publicId, Reader reader, InputStream stream, String encoding) throws Exception {
        this.basePublicId = publicId;
        this.baseURI = systemId;
        this.baseReader = reader;
        this.baseInputStream = stream;
        this.initializeVariables();
        this.setInternalEntity(this.intern("amp"), "&#38;");
        this.setInternalEntity(this.intern("lt"), "&#60;");
        this.setInternalEntity(this.intern("gt"), "&#62;");
        this.setInternalEntity(this.intern("apos"), "&#39;");
        this.setInternalEntity(this.intern("quot"), "&#34;");
        if (this.handler != null) {
            this.handler.startDocument();
        }
        this.pushURL("[document]", this.basePublicId, this.baseURI, this.baseReader, this.baseInputStream, encoding);
        this.parseDocument();
        if (this.handler != null) {
            this.handler.endDocument();
        }
        this.cleanupVariables();
    }

    void error(String message, String textFound, String textExpected) throws Exception {
        ++this.errorCount;
        if (textFound != null) {
            message = message + " (found \"" + textFound + "\")";
        }
        if (textExpected != null) {
            message = message + " (expected \"" + textExpected + "\")";
        }
        if (this.handler != null) {
            String uri = null;
            if (this.externalEntity != null) {
                uri = this.externalEntity.getURL().toString();
            }
            this.handler.error(message, uri, this.line, this.column);
        }
    }

    void error(String message, char textFound, String textExpected) throws Exception {
        this.error(message, new Character(textFound).toString(), textExpected);
    }

    void parseDocument() throws Exception {
        this.parseProlog();
        this.require('<');
        this.parseElement();
        try {
            this.parseMisc();
            char c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException e) {
            return;
        }
    }

    void parseComment() throws Exception {
        this.skipUntil("-->");
    }

    void parsePI() throws Exception {
        String name = this.readNmtoken(true);
        if (!this.tryRead("?>")) {
            this.requireWhitespace();
            this.parseUntil("?>");
        }
        if (this.handler != null) {
            this.handler.processingInstruction(name, this.dataBufferToString());
        }
    }

    void parseCDSect() throws Exception {
        this.parseUntil("]]>");
    }

    void parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
        }
    }

    void parseXMLDecl(boolean ignoreEncoding) throws Exception {
        String encodingName = null;
        String standalone = null;
        this.require("version");
        this.parseEq();
        String version = this.readLiteral(0);
        if (!version.equals("1.0")) {
            this.error("unsupported XML version", version, "1.0");
        }
        this.skipWhitespace();
        if (this.tryRead("encoding")) {
            this.parseEq();
            encodingName = this.readLiteral(0);
            this.checkEncoding(encodingName, ignoreEncoding);
        }
        this.skipWhitespace();
        if (this.tryRead("standalone")) {
            this.parseEq();
            standalone = this.readLiteral(0);
        }
        this.skipWhitespace();
        this.require("?>");
    }

    void parseTextDecl(boolean ignoreEncoding) throws Exception {
        String encodingName = null;
        if (this.tryRead("version")) {
            this.parseEq();
            String version = this.readLiteral(0);
            if (!version.equals("1.0")) {
                this.error("unsupported XML version", version, "1.0");
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        encodingName = this.readLiteral(0);
        this.checkEncoding(encodingName, ignoreEncoding);
        this.skipWhitespace();
        this.require("?>");
    }

    void checkEncoding(String encodingName, boolean ignoreEncoding) throws Exception {
        encodingName = encodingName.toUpperCase();
        if (ignoreEncoding) {
            return;
        }
        switch (this.encoding) {
            case 1: {
                if (encodingName.equals("ISO-8859-1")) {
                    this.encoding = 2;
                    break;
                }
                if (encodingName.equals("UTF-8")) break;
                this.error("unsupported 8-bit encoding", encodingName, "UTF-8 or ISO-8859-1");
                break;
            }
            case 3: 
            case 4: {
                if (encodingName.equals("ISO-10646-UCS-2") || encodingName.equals("UTF-16")) break;
                this.error("unsupported 16-bit encoding", encodingName, "ISO-10646-UCS-2");
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (encodingName.equals("ISO-10646-UCS-4")) break;
                this.error("unsupported 32-bit encoding", encodingName, "ISO-10646-UCS-4");
            }
        }
    }

    void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead("<?")) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead("<!--")) break;
            this.parseComment();
        }
    }

    void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String doctypeName = this.readNmtoken(true);
        this.skipWhitespace();
        String[] ids = this.readExternalIds(false);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.context = 1;
                this.skipWhitespace();
                this.context = 0;
                if (this.tryRead(']')) break;
                this.context = 1;
                this.parseMarkupdecl();
                this.context = 0;
            }
        }
        if (ids[1] != null) {
            this.pushURL("[external subset]", ids[0], ids[1], null, null, null);
            while (true) {
                this.context = 1;
                this.skipWhitespace();
                this.context = 0;
                if (!this.tryRead('>')) {
                    this.context = 1;
                    this.parseMarkupdecl();
                    this.context = 0;
                    continue;
                }
                break;
            }
        } else {
            this.skipWhitespace();
            this.require('>');
        }
        if (this.handler != null) {
            this.handler.doctypeDecl(doctypeName, ids[0], ids[1]);
        }
    }

    void parseMarkupdecl() throws Exception {
        if (this.tryRead("<!ELEMENT")) {
            this.parseElementdecl();
        } else if (this.tryRead("<!ATTLIST")) {
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            this.parseNotationDecl();
        } else if (this.tryRead("<?")) {
            this.parsePI();
        } else if (this.tryRead("<!--")) {
            this.parseComment();
        } else if (this.tryRead("<![")) {
            this.parseConditionalSect();
        } else {
            this.error("expected markup declaration", null, null);
        }
    }

    void parseElement() throws Exception {
        String gi;
        int oldElementContent = this.currentElementContent;
        String oldElement = this.currentElement;
        this.tagAttributePos = 0;
        this.currentElement = gi = this.readNmtoken(true);
        this.currentElementContent = this.getElementContentType(gi);
        if (this.currentElementContent == 0) {
            this.currentElementContent = 1;
        }
        this.skipWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            this.parseAttribute(gi);
            this.skipWhitespace();
            c = this.readCh();
        }
        this.unread(c);
        Enumeration atts = this.declaredAttributes(gi);
        if (atts != null) {
            block5: while (atts.hasMoreElements()) {
                String aname = (String)atts.nextElement();
                int i = 0;
                while (i < this.tagAttributePos) {
                    if (this.tagAttributes[i] == aname) continue block5;
                    ++i;
                }
                if (this.handler == null) continue;
                this.handler.attribute(aname, this.getAttributeExpandedValue(gi, aname), false);
            }
        }
        c = this.readCh();
        switch (c) {
            case '>': {
                if (this.handler != null) {
                    this.handler.startElement(gi);
                }
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                if (this.handler == null) break;
                this.handler.startElement(gi);
                this.handler.endElement(gi);
            }
        }
        this.currentElement = oldElement;
        this.currentElementContent = oldElementContent;
    }

    void parseAttribute(String name) throws Exception {
        String aname = this.readNmtoken(true).intern();
        int type = this.getAttributeType(name, aname);
        this.parseEq();
        String value = type == 1 || type == 0 ? this.readLiteral(3) : this.readLiteral(11);
        if (this.handler != null) {
            this.handler.attribute(aname, value, true);
        }
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] newAttrib = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, newAttrib, 0, this.tagAttributePos);
            this.tagAttributes = newAttrib;
        }
        this.tagAttributes[this.tagAttributePos++] = aname;
    }

    void parseEq() throws Exception {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    void parseETag() throws Exception {
        String name = this.readNmtoken(true);
        if (name != this.currentElement) {
            this.error("mismatched end tag", name, this.currentElement);
        }
        this.skipWhitespace();
        this.require('>');
        if (this.handler != null) {
            this.handler.endElement(name);
        }
    }

    void parseContent() throws Exception {
        while (true) {
            switch (this.currentElementContent) {
                case 1: 
                case 3: {
                    this.parsePCData();
                    break;
                }
                case 4: {
                    this.parseWhitespace();
                }
            }
            char c = this.readCh();
            block4 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                        break;
                    }
                    this.unread(c);
                    this.parseEntityRef(true);
                    break;
                }
                case '<': {
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-');
                                    this.parseComment();
                                    break block4;
                                }
                                case '[': {
                                    this.require("CDATA[");
                                    this.parseCDSect();
                                    break block4;
                                }
                            }
                            this.error("expected comment or CDATA section", c, null);
                            break block4;
                        }
                        case '?': {
                            this.dataBufferFlush();
                            this.parsePI();
                            break block4;
                        }
                        case '/': {
                            this.dataBufferFlush();
                            this.parseETag();
                            return;
                        }
                    }
                    this.dataBufferFlush();
                    this.unread(c);
                    this.parseElement();
                }
            }
        }
    }

    void parseElementdecl() throws Exception {
        this.requireWhitespace();
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(name);
        this.skipWhitespace();
        this.require('>');
    }

    void parseContentspec(String name) throws Exception {
        if (this.tryRead("EMPTY")) {
            this.setElement(name, 2, null, null);
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(name, 1, null, null);
            return;
        }
        this.require('(');
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed();
            this.setElement(name, 3, this.dataBufferToString(), null);
        } else {
            this.parseElements();
            this.setElement(name, 4, this.dataBufferToString(), null);
        }
    }

    void parseElements() throws Exception {
        char sep;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c = this.readCh();
        switch (c) {
            case ')': {
                this.dataBufferAppend(')');
                c = this.readCh();
                switch (c) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c);
                        break;
                    }
                    default: {
                        this.unread(c);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                sep = c;
                this.dataBufferAppend(c);
                break;
            }
            default: {
                this.error("bad separator in content model", c, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c = this.readCh();
            if (c == ')') break;
            if (c != sep) {
                this.error("bad separator in content model", c, null);
                return;
            }
            this.dataBufferAppend(c);
        }
        this.dataBufferAppend(')');
        c = this.readCh();
        switch (c) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c);
                return;
            }
        }
        this.unread(c);
    }

    void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements();
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    void parseMixed() throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")*")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(")*");
    }

    void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String elementName = this.readNmtoken(true);
        this.requireWhitespace();
        while (!this.tryRead('>')) {
            this.parseAttDef(elementName);
            this.skipWhitespace();
        }
    }

    void parseAttDef(String elementName) throws Exception {
        String string = null;
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        int type = this.readAttType();
        if (type == 9 || type == 10) {
            string = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(elementName, name, type, string);
    }

    int readAttType() throws Exception {
        Integer type;
        if (this.tryRead('(')) {
            this.parseEnumeration();
            return 9;
        }
        String typeString = this.readNmtoken(true);
        if (typeString.equals("NOTATION")) {
            this.parseNotationType();
        }
        if ((type = (Integer)attributeTypeHash.get(typeString)) == null) {
            this.error("illegal attribute type", typeString, null);
            return 0;
        }
        return type;
    }

    void parseEnumeration() throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(true));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration();
    }

    void parseDefault(String elementName, String name, int type, String string) throws Exception {
        int valueType = 1;
        String value = null;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                valueType = 4;
                this.requireWhitespace();
                this.context = 3;
                value = this.readLiteral(1);
                this.context = 1;
            } else if (this.tryRead("REQUIRED")) {
                valueType = 3;
            } else if (this.tryRead("IMPLIED")) {
                valueType = 2;
            } else {
                this.error("illegal keyword for attribute default value", null, null);
            }
        } else {
            this.context = 3;
            value = this.readLiteral(1);
            this.context = 1;
        }
        this.setAttribute(elementName, name, type, string, value, valueType);
    }

    void parseConditionalSect() throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            boolean nesting = true;
            int nest = 1;
            while (nest > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (this.tryRead("![")) {
                            ++nest;
                        }
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --nest;
                    }
                }
            }
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE", null, null);
        }
    }

    void parseCharRef() throws Exception {
        int value = 0;
        if (this.tryRead('x')) {
            block8: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        value *= 16;
                        value += Integer.parseInt(new Character(c).toString(), 16);
                        continue block8;
                    }
                    case ';': {
                        break block8;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block8;
                    }
                }
                break;
            }
        } else {
            block9: while (true) {
                char c = this.readCh();
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value *= 10;
                        value += Integer.parseInt(new Character(c).toString(), 10);
                        continue block9;
                    }
                    case ';': {
                        break block9;
                    }
                    default: {
                        this.error("illegal character in character reference", c, null);
                        break block9;
                    }
                }
                break;
            }
        }
        if (value <= 65535) {
            this.dataBufferAppend((char)value);
        } else if (value <= 1048575) {
            this.dataBufferAppend((char)(0xD8 | (value & 0xFFC00) >> 10));
            this.dataBufferAppend((char)(0xDC | value & 0x3FF));
        } else {
            this.error("character reference " + value + " is too large for UTF-16", new Integer(value).toString(), null);
        }
    }

    void parseEntityRef(boolean externalAllowed) throws Exception {
        String name = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                this.error("reference to undeclared entity", name, null);
                break;
            }
            case 1: {
                this.pushString(name, this.getEntityValue(name));
                break;
            }
            case 3: {
                if (externalAllowed) {
                    this.pushURL(name, this.getEntityPublicId(name), this.getEntitySystemId(name), null, null, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
                break;
            }
            case 2: {
                if (externalAllowed) {
                    this.error("data entity reference in content", name, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
            }
        }
    }

    void parsePEReference(boolean isEntityValue) throws Exception {
        String name = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                this.error("reference to undeclared parameter entity", name, null);
                break;
            }
            case 1: {
                if (isEntityValue) {
                    this.pushString(name, this.getEntityValue(name));
                    break;
                }
                this.pushString(name, " " + this.getEntityValue(name) + ' ');
                break;
            }
            case 3: {
                if (isEntityValue) {
                    this.pushString(null, " ");
                }
                this.pushURL(name, this.getEntityPublicId(name), this.getEntitySystemId(name), null, null, null);
                if (!isEntityValue) break;
                this.pushString(null, " ");
            }
        }
    }

    void parseEntityDecl() throws Exception {
        boolean peFlag = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            peFlag = true;
            this.requireWhitespace();
        }
        String name = this.readNmtoken(true);
        if (peFlag) {
            name = "%" + name;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            this.context = 2;
            String value = this.readLiteral(5);
            this.context = 1;
            this.setInternalEntity(name, value);
        } else {
            String[] ids = this.readExternalIds(false);
            if (ids[1] == null) {
                this.error("system identifier missing", name, null);
            }
            this.skipWhitespace();
            if (this.tryRead("NDATA")) {
                this.requireWhitespace();
                String notationName = this.readNmtoken(true);
                this.setExternalDataEntity(name, ids[0], ids[1], notationName);
            } else {
                this.setExternalTextEntity(name, ids[0], ids[1]);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String nname = this.readNmtoken(true);
        this.requireWhitespace();
        String[] ids = this.readExternalIds(true);
        if (ids[0] == null && ids[1] == null) {
            this.error("external identifier missing", nname, null);
        }
        this.setNotation(nname, ids[0], ids[1]);
        this.skipWhitespace();
        this.require('>');
    }

    void parsePCData() throws Exception {
        int lineAugment = 0;
        int columnAugment = 0;
        int i = this.readBufferPos;
        while (i < this.readBufferLength) {
            switch (this.readBuffer[i]) {
                case '\n': {
                    ++lineAugment;
                    columnAugment = 0;
                    break;
                }
                case '&': 
                case '<': {
                    int start = this.readBufferPos;
                    ++columnAugment;
                    this.readBufferPos = i;
                    if (lineAugment > 0) {
                        this.line += lineAugment;
                        this.column = columnAugment;
                    } else {
                        this.column += columnAugment;
                    }
                    this.dataBufferAppend(this.readBuffer, start, i - start);
                    return;
                }
                default: {
                    ++columnAugment;
                }
            }
            ++i;
        }
        while (true) {
            char c = this.readCh();
            switch (c) {
                case '&': 
                case '<': {
                    this.unread(c);
                    return;
                }
            }
            this.dataBufferAppend(c);
        }
    }

    void requireWhitespace() throws Exception {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace expected", c, null);
        }
    }

    void parseWhitespace() throws Exception {
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            this.dataBufferAppend(c);
            c = this.readCh();
        }
        this.unread(c);
    }

    void skipWhitespace() throws Exception {
        int lineAugment = 0;
        int columnAugment = 0;
        int i = this.readBufferPos;
        block5: while (i < this.readBufferLength) {
            switch (this.readBuffer[i]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++columnAugment;
                    break;
                }
                case '\n': {
                    ++lineAugment;
                    columnAugment = 0;
                    break;
                }
                case '%': {
                    if (this.context == 1 || this.context == 2) break block5;
                }
                default: {
                    this.readBufferPos = i;
                    if (lineAugment > 0) {
                        this.line += lineAugment;
                        this.column = columnAugment;
                    } else {
                        this.column += columnAugment;
                    }
                    return;
                }
            }
            ++i;
        }
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    String readNmtoken(boolean isName) throws Exception {
        int i = this.readBufferPos;
        block7: while (i < this.readBufferLength) {
            switch (this.readBuffer[i]) {
                case '%': {
                    if (this.context == 1 || this.context == 2) break block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '#': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int start = this.readBufferPos;
                    if (i == start) {
                        this.error("name expected", this.readBuffer[i], null);
                    }
                    this.readBufferPos = i;
                    return this.intern(this.readBuffer, start, i - start);
                }
                default: {
                    ++i;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            char c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected", null, null);
                    }
                    String s = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return s;
                }
            }
            this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readLiteral(int flags) throws Exception {
        int startLine = this.line;
        char delim = this.readCh();
        if (delim != '\"' && delim != '\'' && delim != '\u0000') {
            this.error("expected '\"' or \"'\"", delim, null);
            return null;
        }
        try {
            char c = this.readCh();
            block6: while (c != delim) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        c = ' ';
                        break;
                    }
                    case '&': {
                        if ((flags & 1) <= 0) break;
                        c = this.readCh();
                        if (c == '#') {
                            this.parseCharRef();
                            c = this.readCh();
                            continue block6;
                        }
                        if ((flags & 2) > 0) {
                            this.unread(c);
                            this.parseEntityRef(false);
                            c = this.readCh();
                            continue block6;
                        }
                        this.dataBufferAppend('&');
                    }
                }
                this.dataBufferAppend(c);
                c = this.readCh();
            }
        }
        catch (EOFException e) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, new Character(delim).toString());
        }
        if ((flags & 8) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    String[] readExternalIds(boolean inNotation) throws Exception {
        String[] ids = new String[2];
        if (this.tryRead("PUBLIC")) {
            this.requireWhitespace();
            ids[0] = this.readLiteral(8);
            if (inNotation) {
                this.skipWhitespace();
                if (this.tryRead('\"') || this.tryRead('\'')) {
                    ids[1] = this.readLiteral(0);
                }
            } else {
                this.requireWhitespace();
                ids[1] = this.readLiteral(0);
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            ids[1] = this.readLiteral(0);
        }
        return ids;
    }

    final boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    void dataBufferAppend(char c) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    void dataBufferAppend(String s) {
        this.dataBufferAppend(s.toCharArray(), 0, s.length());
    }

    void dataBufferAppend(char[] ch, int start, int length) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + length);
        System.arraycopy(ch, start, this.dataBuffer, this.dataBufferPos, length);
        this.dataBufferPos += length;
    }

    void dataBufferNormalize() {
        int i = 0;
        int j = 0;
        int end = this.dataBufferPos;
        while (j < end && this.isWhitespace(this.dataBuffer[j])) {
            ++j;
        }
        while (end > j && this.isWhitespace(this.dataBuffer[end - 1])) {
            --end;
        }
        while (j < end) {
            char c;
            if (this.isWhitespace(c = this.dataBuffer[j++])) {
                while (j < end && this.isWhitespace(this.dataBuffer[j++])) {
                }
                this.dataBuffer[i++] = 32;
                this.dataBuffer[i++] = this.dataBuffer[j - 1];
                continue;
            }
            this.dataBuffer[i++] = c;
        }
        this.dataBufferPos = i;
    }

    String dataBufferToString() {
        String s = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return s;
    }

    void dataBufferFlush() throws Exception {
        if (this.dataBufferPos > 0) {
            switch (this.currentElementContent) {
                case 0: 
                case 2: {
                    break;
                }
                case 1: 
                case 3: {
                    if (this.handler == null) break;
                    this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                    break;
                }
                case 4: {
                    if (this.handler == null) break;
                    this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                }
            }
            this.dataBufferPos = 0;
        }
    }

    void require(String delim) throws Exception {
        char[] ch = delim.toCharArray();
        int i = 0;
        while (i < ch.length) {
            this.require(ch[i]);
            ++i;
        }
    }

    void require(char delim) throws Exception {
        char c = this.readCh();
        if (c != delim) {
            this.error("expected character", c, new Character(delim).toString());
        }
    }

    public String intern(String s) {
        char[] ch = s.toCharArray();
        return this.intern(ch, 0, ch.length);
    }

    public String intern(char[] ch, int start, int length) {
        int hash = 0;
        int i = start;
        while (i < start + length) {
            hash = (hash << 1 & 0xFFFFFF) + ch[i];
            ++i;
        }
        Object[] bucket = (Object[])this.symbolTable[hash %= 1087];
        if (bucket == null) {
            bucket = new Object[8];
            this.symbolTable[hash] = bucket;
        }
        int index = 0;
        while (index < bucket.length) {
            char[] chFound = (char[])bucket[index];
            if (chFound == null) break;
            if (chFound.length == length) {
                int i2 = 0;
                while (i2 < chFound.length) {
                    if (ch[start + i2] != chFound[i2]) break;
                    if (i2 == length - 1) {
                        return (String)bucket[index + 1];
                    }
                    ++i2;
                }
            }
            index += 2;
        }
        bucket = (Object[])this.extendArray(bucket, bucket.length, index);
        String s = new String(ch, start, length);
        bucket[index] = s.toCharArray();
        bucket[index + 1] = s;
        this.symbolTable[hash] = bucket;
        return s;
    }

    Object extendArray(Object array, int currentSize, int requiredSize) {
        if (requiredSize < currentSize) {
            return array;
        }
        Object[] newArray = null;
        int newSize = currentSize * 2;
        if (newSize <= requiredSize) {
            newSize = requiredSize + 1;
        }
        if (array instanceof char[]) {
            newArray = new char[currentSize * 2];
        } else if (array instanceof Object[]) {
            newArray = new Object[currentSize * 2];
        }
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    public Enumeration declaredElements() {
        return this.elementInfo.keys();
    }

    public int getElementContentType(String name) {
        Object[] element = (Object[])this.elementInfo.get(name);
        if (element == null) {
            return 0;
        }
        return (Integer)element[0];
    }

    public String getElementContentModel(String name) {
        Object[] element = (Object[])this.elementInfo.get(name);
        if (element == null) {
            return null;
        }
        return (String)element[1];
    }

    void setElement(String name, int contentType, String contentModel, Hashtable attributes) throws Exception {
        Object[] element = (Object[])this.elementInfo.get(name);
        if (element == null) {
            element = new Object[]{new Integer(0), null, null};
        } else if (contentType != 0 && (Integer)element[0] != 0) {
            this.error("multiple declarations for element type", name, null);
            return;
        }
        if (contentType != 0) {
            element[0] = new Integer(contentType);
        }
        if (contentModel != null) {
            element[1] = contentModel;
        }
        if (attributes != null) {
            element[2] = attributes;
        }
        this.elementInfo.put(name, element);
    }

    Hashtable getElementAttributes(String name) {
        Object[] element = (Object[])this.elementInfo.get(name);
        if (element == null) {
            return null;
        }
        return (Hashtable)element[2];
    }

    public Enumeration declaredAttributes(String elname) {
        Hashtable attlist = this.getElementAttributes(elname);
        if (attlist == null) {
            return null;
        }
        return attlist.keys();
    }

    public int getAttributeType(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return 0;
        }
        return (Integer)attribute[0];
    }

    public String getAttributeEnumeration(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        return (String)attribute[3];
    }

    public String getAttributeDefaultValue(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return null;
        }
        return (String)attribute[1];
    }

    public String getAttributeExpandedValue(String name, String aname) {
        Object[] attribute;
        block3: {
            attribute = this.getAttribute(name, aname);
            if (attribute == null) {
                return null;
            }
            if (attribute[4] != null || attribute[1] == null) break block3;
            try {
                this.pushString(null, '\u0000' + (String)attribute[1] + '\u0000');
                attribute[4] = this.readLiteral(11);
            }
            catch (Exception e) {}
        }
        return (String)attribute[4];
    }

    public int getAttributeDefaultValueType(String name, String aname) {
        Object[] attribute = this.getAttribute(name, aname);
        if (attribute == null) {
            return 0;
        }
        return (Integer)attribute[2];
    }

    void setAttribute(String elName, String name, int type, String enumeration, String value, int valueType) throws Exception {
        Hashtable<String, Object[]> attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            attlist = new Hashtable<String, Object[]>();
        }
        if (attlist.get(name) != null) {
            return;
        }
        Object[] attribute = new Object[]{new Integer(type), value, new Integer(valueType), enumeration, null};
        attlist.put(name.intern(), attribute);
        this.setElement(elName, 0, null, attlist);
    }

    Object[] getAttribute(String elName, String name) {
        Hashtable attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            return null;
        }
        Object[] attribute = (Object[])attlist.get(name);
        return attribute;
    }

    public Enumeration declaredEntities() {
        return this.entityInfo.keys();
    }

    public String getCurrentElement() {
        return this.currentElement;
    }

    public int getEntityType(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return 0;
        }
        return (Integer)entity[0];
    }

    public String getEntityPublicId(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[1];
    }

    public String getEntitySystemId(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[2];
    }

    public String getEntityValue(String ename) {
        Object[] entity = (Object[])this.entityInfo.get(ename);
        if (entity == null) {
            return null;
        }
        return (String)entity[3];
    }

    public String getEntityNotationName(String eName) {
        Object[] entity = (Object[])this.entityInfo.get(eName);
        if (entity == null) {
            return null;
        }
        return (String)entity[4];
    }

    void setInternalEntity(String eName, String value) {
        this.setEntity(eName, 1, null, null, value, null);
    }

    void setExternalDataEntity(String eName, String pubid, String sysid, String nName) {
        this.setEntity(eName, 2, pubid, sysid, null, nName);
    }

    void setExternalTextEntity(String eName, String pubid, String sysid) {
        this.setEntity(eName, 3, pubid, sysid, null, null);
    }

    void setEntity(String eName, int eClass, String pubid, String sysid, String value, String nName) {
        if (this.entityInfo.get(eName) == null) {
            Object[] entity = new Object[]{new Integer(eClass), pubid, sysid, value, nName};
            this.entityInfo.put(eName, entity);
        }
    }

    public Enumeration declaredNotations() {
        return this.notationInfo.keys();
    }

    public String getNotationPublicId(String nname) {
        Object[] notation = (Object[])this.notationInfo.get(nname);
        if (notation == null) {
            return null;
        }
        return (String)notation[0];
    }

    public String getNotationSystemId(String nname) {
        Object[] notation = (Object[])this.notationInfo.get(nname);
        if (notation == null) {
            return null;
        }
        return (String)notation[1];
    }

    void setNotation(String nname, String pubid, String sysid) throws Exception {
        if (this.notationInfo.get(nname) == null) {
            Object[] notation = new Object[]{pubid, sysid};
            this.notationInfo.put(nname, notation);
        } else {
            this.error("multiple declarations of notation", nname, null);
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    char readCh() throws Exception {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 2: 
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
                default: {
                    this.popInput();
                }
            }
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '%' && (this.context == 1 || this.context == 2)) {
            char c2 = this.readCh();
            this.unread(c2);
            if (!this.isWhitespace(c2)) {
                this.parsePEReference(this.context == 2);
                return this.readCh();
            }
        }
        if (c == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        return c;
    }

    void unread(char c) throws Exception {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    void unread(char[] ch, int length) throws Exception {
        int i = 0;
        while (i < length) {
            if (ch[i] == '\n') {
                --this.line;
                this.column = -1;
            }
            ++i;
        }
        if (length < this.readBufferPos) {
            this.readBufferPos -= length;
        } else {
            this.pushCharArray(null, ch, 0, length);
            this.sourceType = 4;
        }
    }

    void pushURL(String ename, String publicId, String systemId, Reader reader, InputStream stream, String encoding) throws Exception {
        Object input;
        boolean ignoreEncoding = false;
        this.pushInput(ename);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.currentByteCount = 0;
        this.dataBufferFlush();
        if (systemId != null && this.externalEntity != null) {
            systemId = new URL(this.externalEntity.getURL(), systemId).toString();
        } else if (this.baseURI != null) {
            try {
                systemId = new URL(new URL(this.baseURI), systemId).toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (systemId != null && this.handler != null && (input = this.handler.resolveEntity(publicId, systemId)) != null) {
            if (input instanceof String) {
                systemId = (String)input;
            } else if (input instanceof InputStream) {
                stream = (InputStream)input;
            } else if (input instanceof Reader) {
                reader = (Reader)input;
            }
        }
        if (this.handler != null) {
            if (systemId != null) {
                this.handler.startExternalEntity(systemId);
            } else {
                this.handler.startExternalEntity("[external stream]");
            }
        }
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        if (stream != null) {
            this.sourceType = 3;
            this.is = stream;
        } else {
            this.sourceType = 2;
            URL url = new URL(systemId);
            this.externalEntity = url.openConnection();
            this.externalEntity.connect();
            this.is = this.externalEntity.getInputStream();
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (encoding == null && this.externalEntity != null) {
            encoding = this.externalEntity.getContentEncoding();
        }
        if (encoding != null) {
            this.checkEncoding(encoding, false);
            ignoreEncoding = true;
        } else {
            this.detectEncoding();
            ignoreEncoding = false;
        }
        this.tryEncodingDecl(ignoreEncoding);
    }

    void tryEncodingDecl(boolean ignoreEncoding) throws Exception {
        if (this.tryRead("<?xml")) {
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    this.parseTextDecl(ignoreEncoding);
                } else {
                    this.parseXMLDecl(ignoreEncoding);
                }
            } else {
                this.unread("xml".toCharArray(), 3);
                this.parsePI();
            }
        }
    }

    void detectEncoding() throws Exception {
        byte[] signature = new byte[4];
        this.is.mark(4);
        this.is.read(signature);
        this.is.reset();
        if (this.tryEncoding(signature, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (this.tryEncoding(signature, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (this.tryEncoding(signature, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (this.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (this.tryEncoding(signature, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (this.tryEncoding(signature, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (this.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity", null, null);
        } else if (this.tryEncoding(signature, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity", null, null);
        } else if (this.tryEncoding(signature, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.read8bitEncodingDeclaration();
        } else {
            this.encoding = 1;
        }
    }

    boolean tryEncoding(byte[] sig, byte b1, byte b2, byte b3, byte b4) {
        return sig[0] == b1 && sig[1] == b2 && sig[2] == b3 && sig[3] == b4;
    }

    boolean tryEncoding(byte[] sig, byte b1, byte b2) {
        return sig[0] == b1 && sig[1] == b2;
    }

    void pushString(String ename, String s) throws Exception {
        char[] ch = s.toCharArray();
        this.pushCharArray(ename, ch, 0, ch.length);
    }

    void pushCharArray(String ename, char[] ch, int start, int length) throws Exception {
        this.pushInput(ename);
        this.sourceType = 1;
        this.readBuffer = ch;
        this.readBufferPos = start;
        this.readBufferLength = length;
        this.readBufferOverflow = -1;
    }

    void pushInput(String ename) throws Exception {
        Object[] input = new Object[12];
        if (ename != null) {
            Enumeration entities = this.entityStack.elements();
            while (entities.hasMoreElements()) {
                String e = (String)entities.nextElement();
                if (e != ename) continue;
                this.error("recursive reference to entity", ename, null);
            }
        }
        this.entityStack.push(ename);
        if (this.sourceType == 0) {
            return;
        }
        input[0] = new Integer(this.sourceType);
        input[1] = this.externalEntity;
        input[2] = this.readBuffer;
        input[3] = new Integer(this.readBufferPos);
        input[4] = new Integer(this.readBufferLength);
        input[5] = new Integer(this.line);
        input[6] = new Integer(this.encoding);
        input[7] = new Integer(this.readBufferOverflow);
        input[8] = this.is;
        input[9] = new Integer(this.currentByteCount);
        input[10] = new Integer(this.column);
        input[11] = this.reader;
        this.inputStack.push(input);
    }

    void popInput() throws Exception {
        switch (this.sourceType) {
            case 2: {
                this.dataBufferFlush();
                if (this.handler == null || this.externalEntity == null) break;
                this.handler.endExternalEntity(this.externalEntity.getURL().toString());
                break;
            }
            case 3: {
                this.dataBufferFlush();
                if (this.baseURI == null || this.handler == null) break;
                this.handler.endExternalEntity(this.baseURI);
                break;
            }
            case 5: {
                this.dataBufferFlush();
                if (this.baseURI == null || this.handler == null) break;
                this.handler.endExternalEntity(this.baseURI);
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("XML parser input stack was empty, end of file or xml fragment reached. Perhaps there is a missing '>' or a comment is unterminated by '->'?");
        }
        Object[] input = (Object[])this.inputStack.pop();
        String string = (String)this.entityStack.pop();
        this.sourceType = (Integer)input[0];
        this.externalEntity = (URLConnection)input[1];
        this.readBuffer = (char[])input[2];
        this.readBufferPos = (Integer)input[3];
        this.readBufferLength = (Integer)input[4];
        this.line = (Integer)input[5];
        this.encoding = (Integer)input[6];
        this.readBufferOverflow = (Integer)input[7];
        this.is = (InputStream)input[8];
        this.currentByteCount = (Integer)input[9];
        this.column = (Integer)input[10];
        this.reader = (Reader)input[11];
    }

    boolean tryRead(char delim) throws Exception {
        char c = this.readCh();
        if (c == delim) {
            return true;
        }
        this.unread(c);
        return false;
    }

    boolean tryRead(String delim) throws Exception {
        char[] ch = delim.toCharArray();
        int i = 0;
        while (i < ch.length) {
            char c = this.readCh();
            if (c != ch[i]) {
                this.unread(c);
                if (i != 0) {
                    this.unread(ch, i);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean tryWhitespace() throws Exception {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    void parseUntil(String delim) throws Exception {
        int startLine = this.line;
        try {
            while (!this.tryRead(delim)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException e) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, delim);
        }
    }

    /*
     * Unable to fully structure code
     */
    void skipUntil(String delim) throws Exception {
        ** GOTO lbl20
        {
            switch (this.sourceType) {
                case 2: 
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    break;
                }
                default: {
                    this.popInput();
                }
            }
            do {
                if (this.readBufferPos >= this.readBufferLength) continue block3;
                if ((c = this.readBuffer[this.readBufferPos++]) == '\n') {
                    ++this.line;
                    this.column = 0;
                    continue;
                }
                ++this.column;
lbl20:
                // 3 sources

            } while (!this.tryRead(delim));
        }
    }

    void read8bitEncodingDeclaration() throws Exception {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        while (true) {
            int ch = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)ch;
            switch (ch) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("end of file before end of XML or encoding declaration.", null, "?>");
                    return;
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration", null, null);
        }
    }

    void readDataChunk() throws Exception {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            int count = this.reader.read(this.readBuffer, this.readBufferPos, 16383);
            if (count < 0) {
                this.readBufferLength = -1;
            } else {
                this.readBufferLength = this.readBufferPos + count;
                this.filterCR();
                this.sawCR = false;
            }
            return;
        }
        int count = this.is.read(this.rawReadBuffer, 0, 16384);
        switch (this.encoding) {
            case 1: {
                this.copyUtf8ReadBuffer(count);
                break;
            }
            case 2: {
                this.copyIso8859_1ReadBuffer(count);
                break;
            }
            case 3: {
                this.copyUcs2ReadBuffer(count, 8, 0);
                break;
            }
            case 4: {
                this.copyUcs2ReadBuffer(count, 0, 8);
                break;
            }
            case 5: {
                this.copyUcs4ReadBuffer(count, 24, 16, 8, 0);
                break;
            }
            case 6: {
                this.copyUcs4ReadBuffer(count, 0, 8, 16, 24);
                break;
            }
            case 7: {
                this.copyUcs4ReadBuffer(count, 16, 24, 0, 8);
                break;
            }
            case 8: {
                this.copyUcs4ReadBuffer(count, 8, 0, 24, 16);
            }
        }
        if (this.sawCR) {
            this.filterCR();
            this.sawCR = false;
        }
        this.readBufferPos = 0;
        this.currentByteCount += count;
    }

    void filterCR() {
        this.readBufferOverflow = -1;
        int i = 0;
        int j = 0;
        block3: while (j < this.readBufferLength) {
            switch (this.readBuffer[j]) {
                case '\r': {
                    if (j == this.readBufferLength - 1) {
                        this.readBufferOverflow = 13;
                        --this.readBufferLength;
                        break block3;
                    }
                    if (this.readBuffer[j + 1] == '\n') {
                        ++j;
                    }
                    this.readBuffer[i] = 10;
                    break;
                }
                default: {
                    this.readBuffer[i] = this.readBuffer[j];
                }
            }
            ++i;
            ++j;
        }
        this.readBufferLength = i;
    }

    void copyUtf8ReadBuffer(int count) throws Exception {
        int i = 0;
        int j = this.readBufferPos;
        boolean isSurrogate = false;
        while (i < count) {
            byte b1 = this.rawReadBuffer[i++];
            isSurrogate = false;
            if ((b1 & 0x80) == 0) {
                this.readBuffer[j++] = (char)b1;
            } else if ((b1 & 0xE0) == 192) {
                this.readBuffer[j++] = (char)((b1 & 0x1F) << 6 | this.getNextUtf8Byte(i++, count));
            } else if ((b1 & 0xF0) == 224) {
                this.readBuffer[j++] = (char)((b1 & 0xF) << 12 | this.getNextUtf8Byte(i++, count) << 6 | this.getNextUtf8Byte(i++, count));
            } else if ((b1 & 0xF8) == 240) {
                isSurrogate = true;
                int b2 = this.getNextUtf8Byte(i++, count);
                int b3 = this.getNextUtf8Byte(i++, count);
                int b4 = this.getNextUtf8Byte(i++, count);
                this.readBuffer[j++] = (char)(0xD800 | ((b1 & 7) << 2 | ((b2 & 0x30) >> 4) - 1) << 6 | (b2 & 0xF) << 2 | (b3 & 0x30) >> 4);
                this.readBuffer[j++] = (char)(0xDC | (b3 & 0xF) << 6 | b4);
            } else {
                this.encodingError("bad start for UTF-8 multi-byte sequence", b1, i);
            }
            if (this.readBuffer[j - 1] != '\r') continue;
            this.sawCR = true;
        }
        this.readBufferLength = j;
    }

    int getNextUtf8Byte(int pos, int count) throws Exception {
        int val;
        if (pos < count) {
            val = this.rawReadBuffer[pos];
        } else {
            val = this.is.read();
            if (val == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, pos);
            }
        }
        if ((val & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", val, pos + 1);
        }
        return val & 0x3F;
    }

    void copyIso8859_1ReadBuffer(int count) {
        int i = 0;
        int j = this.readBufferPos;
        while (i < count) {
            this.readBuffer[j] = (char)(this.rawReadBuffer[i] & 0xFF);
            if (this.readBuffer[j] == '\r') {
                this.sawCR = true;
            }
            ++i;
            ++j;
        }
        this.readBufferLength = j;
    }

    void copyUcs2ReadBuffer(int count, int shift1, int shift2) throws Exception {
        int j = this.readBufferPos;
        if (count > 0 && count % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, count);
        }
        int i = 0;
        while (i < count) {
            this.readBuffer[j++] = (char)((this.rawReadBuffer[i] & 0xFF) << shift1 | (this.rawReadBuffer[i + 1] & 0xFF) << shift2);
            if (this.readBuffer[j - 1] == '\r') {
                this.sawCR = true;
            }
            i += 2;
        }
        this.readBufferLength = j;
    }

    void copyUcs4ReadBuffer(int count, int shift1, int shift2, int shift3, int shift4) throws Exception {
        int j = this.readBufferPos;
        if (count > 0 && count % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, count);
        }
        int i = 0;
        while (i < count) {
            int value = (this.rawReadBuffer[i] & 0xFF) << shift1 | (this.rawReadBuffer[i + 1] & 0xFF) << shift2 | (this.rawReadBuffer[i + 2] & 0xFF) << shift3 | (this.rawReadBuffer[i + 3] & 0xFF) << shift4;
            if (value < 65535) {
                this.readBuffer[j++] = (char)value;
                if (value == 13) {
                    this.sawCR = true;
                }
            } else if (value < 1048575) {
                this.readBuffer[j++] = (char)(0xD8 | (value & 0xFFC00) >> 10);
                this.readBuffer[j++] = (char)(0xDC | value & 0x3FF);
            } else {
                this.encodingError("value cannot be represented in UTF-16", value, i);
            }
            i += 4;
        }
        this.readBufferLength = j;
    }

    void encodingError(String message, int value, int offset) throws Exception {
        if (value >= 0) {
            message = message + " (byte value: 0x" + Integer.toHexString(value) + ')';
        }
        String uri = this.externalEntity != null ? this.externalEntity.getURL().toString() : this.baseURI;
        this.handler.error(message, uri, -1, offset + this.currentByteCount);
    }

    void initializeVariables() {
        this.errorCount = 0;
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new Hashtable();
        this.entityInfo = new Hashtable();
        this.notationInfo = new Hashtable();
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new Stack();
        this.entityStack = new Stack();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.context = 0;
        this.symbolTable = new Object[1087];
    }

    void cleanupVariables() {
        this.errorCount = -1;
        this.line = -1;
        this.column = -1;
        this.dataBuffer = null;
        this.nameBuffer = null;
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = null;
        this.externalEntity = null;
        this.entityStack = null;
    }

    static {
        attributeTypeHash.put("CDATA", new Integer(1));
        attributeTypeHash.put("ID", new Integer(2));
        attributeTypeHash.put("IDREF", new Integer(3));
        attributeTypeHash.put("IDREFS", new Integer(4));
        attributeTypeHash.put("ENTITY", new Integer(5));
        attributeTypeHash.put("ENTITIES", new Integer(6));
        attributeTypeHash.put("NMTOKEN", new Integer(7));
        attributeTypeHash.put("NMTOKENS", new Integer(8));
        attributeTypeHash.put("NOTATION", new Integer(10));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
    }
}

