% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_ConvertDischarge.R
\name{ConvertDischarge}
\alias{ConvertDischarge}
\title{Calculate Specific runoff from volumetric discharge and vice versa}
\usage{
ConvertDischarge(q, area, from = "m3s", to = "mmd")
}
\arguments{
\item{q}{An object of type \code{numeric}, containing volumetric or specific discharge values,
typically HYPE variables COUT or ROUT.}

\item{area}{An object of type \code{numeric}, containing a catchment area in \eqn{m^2}.}

\item{from}{Character string keyword, giving the current unit of \code{q}. Either a specific discharge, one of:

\code{"mmy"} (\eqn{mm y^{-1}})

\code{"mmd"} (\eqn{mm d^{-1}})

\code{"mmh"} (\eqn{mm h^{-1}}),

or a volumetric discharge, one of:

\code{"m3s"} (\eqn{m^3 s^{-1}})

\code{"ls"} (\eqn{l s^{-1}}).}

\item{to}{Character string keyword, see \code{from}. Conversion will not work between units within volumetric or specific discharge groups.}
}
\value{
\code{ConvertDischarge} returns a numeric object of the same type as provided in argument \code{q}.
}
\description{
\code{ConvertDischarge} converts volumetric discharge to specific discharge (unit area discharge) and vice versa.
}
\details{
\code{ConvertDischarge} is a simple conversion function, most likely to be used in combination with \code{\link{apply}}
or related functions.
}
\examples{
ConvertDischarge(6, 400000000)
ConvertDischarge(c(1.1, 1.2, 1.9, 2.8, 2, 1.5, 1.3, 1.2, 1.15, 1.1), 
                 from = "mmd", to = "ls", area = 1.2e6)
}
