% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ncdf.R
\name{format_ncdf}
\alias{format_ncdf}
\title{Return an array with ncdf data}
\usage{
format_ncdf(
  ncdf,
  label.latitude = "latitude",
  label.longitude = "longitude",
  label.time = "time",
  varid = NULL
)
}
\arguments{
\item{ncdf}{An object read from package ncdf4 or a file name of ncdf file}

\item{label.latitude}{Label of latitude}

\item{label.longitude}{Label of longitude}

\item{label.time}{Label of time}

\item{varid}{Name of variable to extract}
}
\value{
A list with two element: data is an array and time is the POSIX.lt time
}
\description{
Return a list with two element: data is an array and time is the POSIX.lt time./cr
If varid is NULL, it shows the available variable of the file.
}
\details{
format_ncdf is used extract information from ncdf file
}
\examples{
\dontrun{
url <- "ftp://ftp.cdc.noaa.gov/Datasets/noaa.oisst.v2.highres/"
url <- paste0(url, "sst.day.mean.2012.v2.nc")
dest <- paste(Sys.getenv("HOME"), "/sst.day.mean.2012.v2.nc", sep="")
download.file(url, dest)
format_ncdf(dest)
}
}
\seealso{
Other ncdf: 
\code{\link{ind_long_lat}()}
}
\author{
Marc Girondot
}
\concept{ncdf}
