% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_MatH.R
\docType{methods}
\name{WH.correlation2}
\alias{WH.correlation2}
\alias{WH.correlation2,MatH,MatH-method}
\alias{WH.correlation2,MatH-method}
\title{Method WH.correlation2}
\usage{
WH.correlation2(object1, object2, ...)

\S4method{WH.correlation2}{MatH,MatH}(object1, object2, w = numeric(0))
}
\arguments{
\item{object1}{a \code{MatH} object}

\item{object2}{a \code{MatH} object}

\item{...}{some optional parameters}

\item{w}{it is possible to add a vector of weights (positive numbers) 
having the same size of the rows of the \code{MatH object}, 
default = equal weight for each row}
}
\value{
a rectangular \code{matrix} with the weighted sum of squares
}
\description{
Compute the correlation matrix using two  \code{MatH} objects having the same number of rows,
 It returns a rectangular a matrix of numbers, consistent with 
a set of distributions equipped with a L2 wasserstein metric.
}
\examples{
M1<-BLOOD[,1]
M2<-BLOOD[,2:3]
WH.correlation2(M1,M2)
# generate a set of random weights
RN<-runif(get.MatH.nrows(BLOOD))
WH.correlation2(M1,M2,w=RN)
}
