% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_summary.R
\name{GOF_summary}
\alias{GOF_summary}
\title{Calculate Goodness-of-fit metrics and output into table}
\usage{
GOF_summary(
  mod,
  obs,
  metrics = c("cor", "kge", "mae", "me", "nse", "pb", "rmse", "nrmse", "ve"),
  censor_threshold = NULL,
  censor_symbol = NULL,
  na.rm = TRUE,
  kge_modified = FALSE,
  nse_j = 2,
  rmse_normalize = c("mean", "range", "stdev", "iqr", "iqr-1", "iqr-2", "iqr-3", "iqr-4",
    "iqr-5", "iqr-6", "iqr-7", "iqr-8", "iqr-9", NULL),
  ...
)
}
\arguments{
\item{mod}{'numeric' vector. Modeled or simulated values. Must be same length as \code{obs}.}

\item{obs}{'numeric' vector. Observed or comparison values. Must be same length as \code{mod}.}

\item{metrics}{'character' vector. Which GOF metrics should be computed and output. Default is
\code{c("cor", "kge", "mae", "me", "nse", "pb", "rmse", "nrmse", "ve")}.\cr
\code{"cor"}. Correlation tests computed from \code{\link{GOF_correlation_tests}}.\cr
\code{"kge"}. Kling--Gupta efficiency computed from \code{\link{GOF_kling_gupta_efficiency}}.\cr
\code{"mae"}. Mean absolute error computed from \code{\link{GOF_mean_absolute_error}}.\cr
\code{"me"}. Mean error computed from \code{\link{GOF_mean_error}}.\cr
\code{"nse"}. Nash--Sutcliffe efficiency computed from\cr
\code{\link{GOF_nash_sutcliffe_efficiency}} with option for modified NSE specified by
parameter \code{nse_j}.\cr
\code{"pb"}. Percent bias computed from \code{\link{GOF_percent_bias}}.\cr
\code{"rmse"}. Root-mean-square error computed from \code{\link{GOF_rmse}}.\cr
\code{"nrmse"}. Normalized root-mean-square error computed from \code{\link{GOF_rmse}} and
"normalize" option specified in parameter \code{rmse_normalize}.\cr
\code{"ve"}. Volumetric efficiency computed from \code{\link{GOF_volumetric_efficiency}}.\cr}

\item{censor_threshold}{'numeric' value. Threshold to censor values on utilizing
\code{\link{censor_values}} function. Default is \code{NULL}, no censoring. If level specified, must also
specify\cr\code{censor_symbol}.}

\item{censor_symbol}{'character' string. Inequality symbol to censor values based on
\code{censor_threshold} utilizing \code{\link{censor_values}} function. Accepted values are\cr
\code{"gt"} (greater than),\cr
\code{"gte"} (greater than or equal to),\cr
\code{"lt"} (less than),\cr
or \code{"lte"} (less than or equal to).\cr
Default is \code{NULL}, no censoring. If symbol specified, must also specify \code{censor_value}.}

\item{na.rm}{'boolean' \code{TRUE} or \code{FALSE}. Should \code{NA} values be removed before computing. If any
\code{NA} values are present in \code{mod} or \code{obs}, the \emph{i}th position from each will be removed before
calculating. If \code{NA} values are present and \code{na.rm = FALSE}, then function will return \code{NA}.
Default is \code{TRUE}.}

\item{kge_modified}{'boolean' \code{TRUE} or \code{FALSE}. Should the KGE calculation use the original
variability ratio in the standard deviations (\code{kge_modified  = FALSE}) or the modified
variability ratio in the coefficient of variations (\code{kge_modified = TRUE}). Default is \code{FALSE}.}

\item{nse_j}{'numeric' value. Exponent value for modified NSE (mNSE) equation, utilized if
\code{"nse"} option is in parameter \code{metrics}. Default value is \code{nse_j = 2}, which is traditional
NSE equation.}

\item{rmse_normalize}{'character' value. Normalize option for NRMSE, utilized if "nrmse" option
is in paramter \code{metrics}. Default is \code{"mean"}. Options are\cr
\code{'mean'}. RMSE is normalized by the mean of \code{obs}.\cr
\code{'range'}. RMSE is normalized by the range \code{(max - min)} of \code{obs}.\cr
\code{'stdev'}. RMSE is normalized by the standard deviation of \code{obs}.\cr
\code{'iqr-#'}. RMSE is normalized by the inter-quartile range of \code{obs}, with distribution type
(see \code{\link[stats:quantile]{stats::quantile}} function) indicated by integer number (for example \code{"iqr-8"}).
If no type specified, default type is \code{iqr-7}, the quantile function default.}

\item{...}{Further arguments to be passed to or from \code{\link[stats:cor.test]{stats::cor.test}} if \code{"cor"} is in
\code{metrics}.}
}
\value{
A tibble (see \code{\link[tibble:tibble]{tibble::tibble}}) with GOF metrics
}
\description{
Calculate Goodness-of-fit (GOF) metrics for correlation, Kling--Gupta efficiency,
mean absolute error, mean error, Nash--Sutcliffe efficiency, percent bias,
root-mean-square error, normalized root-mean-square error, and volumetric efficiency, and output
into a table.
}
\details{
See \code{\link{GOF_correlation_tests}}, \code{\link{GOF_kling_gupta_efficiency}},\cr
\code{\link{GOF_mean_absolute_error}}, \code{\link{GOF_mean_error}}, \cr
\code{\link{GOF_nash_sutcliffe_efficiency}}, \code{\link{GOF_percent_bias}}, \code{\link{GOF_rmse}},\cr
and \code{\link{GOF_volumetric_efficiency}}.
}
\examples{
GOF_summary(mod = example_mod$streamflow_cfs, obs = example_obs$streamflow_cfs)

}
\seealso{
\code{\link{censor_values}}, \code{\link{GOF_correlation_tests}},
\code{\link{GOF_kling_gupta_efficiency}},
\code{\link{GOF_mean_absolute_error}}, \code{\link{GOF_mean_error}}, \cr
\code{\link{GOF_nash_sutcliffe_efficiency}}, \code{\link{GOF_percent_bias}},
\code{\link{GOF_rmse}}, \cr
\code{\link{GOF_volumetric_efficiency}}
}
\keyword{goodness-of-fit}
