% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNTfut.R
\name{plotNT.fut}
\alias{plotNT.fut}
\title{Plotting N-T Plane for Decision on Performing an Interim Analysis}
\usage{
plotNT.fut(p0, M, q, alpha1, cp1,
            xlab = "N: Number of patients at interim analysis",
            ylab = "T: Number of responders at interim analysis",
            col = "blue",
            main = "N-T plot",
            lty = 2,...)
}
\arguments{
\item{p0}{Expected response rate for the control arm: scalar or vector. the value between 0 to 1.}

\item{M}{Total number of patients: expected number of patients until last time.}

\item{q}{Allocation ratio of the treatment arm: the value between 0 to 1.}

\item{alpha1}{Critical alpha at an interim analysis.}

\item{cp1}{Critical conditional power at an interim analysis.}

\item{xlab}{Label name for x-axis in N-T plot.}

\item{ylab}{Label name for y-axis in N-T plot.}

\item{col}{Line color. Default is "blue". For multiple p0, set the same length of color with p0.}

\item{main}{Main title in N-T plot.}

\item{lty}{Line type. The default is 2 for early stopping for futility.}

\item{...}{Other graphics parameters}
}
\value{
A matrix or list with variable names \code{N}, \code{T}, \code{Z_score} and \code{CP}.

Draw N-T plot for early stopping for futility

\item{x axis:}{N (Total number of patients at interim analysis)}

\item{y axis:}{T (Total number of responders at interim analysis)}
}
\description{
The package plots N-T plane for decision for conducting an interim analysis in a randomized control trial.
The functions for interim analysis expecting early stopping for superiority and futility are prepared respectively.
}
\details{
For more details, please refer to the vignette: \code{browseVignettes(package = "IAbin")}
}
\examples{
#--- Settings ---#
#--- With an expected parameter for control therapy ---#
p0 = 0.5
M = 135
q = 2/3
alpha1 = 0.01
cp1 = 0.2

#--- N-T plot for early stopping for superiority and futility ---#
NT_f = plotNT.fut(p0, M, q, alpha1, cp1)
print(NT_f)

#--- Settings ---#
#--- With several expected parameters for control therapy ---#
p0 = c(0.2, 0.4, 0.6)
M = 135
q = 2/3
alpha1 = 0.01
col = c(1, 2, 3)
cp1 = 0.2

#--- N-T plot for early stopping for superiority and futility ---#
NT_f3 = plotNT.fut(p0, M, q, alpha1, cp1, col=col)
print(NT_f3)

}
\references{
Decision on Performing Interim Analysis for Comparative Clinical Trials
}
