% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-UserBayesFunctions.R
\name{sens.bayes.control}
\alias{sens.bayes.control}
\title{Returns Control Parameters for Approximating The Integrals In The Bayesian Sensitivity Functions}
\usage{
sens.bayes.control(
  method = c("cubature", "quadrature"),
  cubature = list(tol = 1e-05, maxEval = 50000, absError = 0),
  quadrature = list(type = c("GLe", "GHe"), level = 6, ndConstruction = "product",
    level.trans = FALSE)
)
}
\arguments{
\item{method}{A character denotes which method to be used to approximate the integrals in Bayesian criteria.
\code{"cubature"} corresponds to the adaptive multivariate integration method using the \code{\link[cubature]{hcubature}} algorithm (default).
\code{"quadrature"} corresponds the traditional quadrature formulas and calls the function \code{\link[mvQuad]{createNIGrid}}.
The tuning parameters are adjusted by \code{crt.bayes.control}. Default is set to \code{"cubature"}.}

\item{cubature}{A list that will be passed to the arguments of the \code{\link[cubature]{hcubature}} function. See 'Details' of \code{\link{crt.bayes.control}}.}

\item{quadrature}{A list that will be passed to the arguments of the \code{\link[mvQuad]{createNIGrid}} function. See 'Details' of \code{\link{crt.bayes.control}}.}
}
\value{
A list of  control parameters for approximating the integrals.
}
\description{
This function returns two lists each corresponds
 to an implemented integration method for approximating the integrals
  in the sensitivity (derivative) functions for the Bayesian optimality criteria.
}
\examples{
sens.bayes.control()
sens.bayes.control(cubature = list(maxEval = 50000))
sens.bayes.control(quadrature =  list(level = 4))
}
